# Receipt & Invoice System - Quick Setup Guide
## KSO Chandigarh Management System

### 🚀 Quick Start (5 Minutes)

#### 1. Database Setup
Run this SQL to create the receipt/invoice tables:

```sql
-- Copy from database/receipt_invoice_setup.sql and execute
SOURCE database/receipt_invoice_setup.sql;
```

#### 2. Test Receipt Generation
```php
// Test via API call
POST /api/receipts/generate
{
    "transaction_id": 1,  // Use existing finance record ID
    "template": "standard"
}
```

#### 3. Access Frontend
1. Open: `frontend/pages/receipts.html`
2. Login with admin credentials
3. View receipt dashboard

---

### 📋 System Status Check

#### ✅ Files Present
- [x] `api/services/ReceiptService.php` - Core service
- [x] `api/receipts/index.php` - API endpoints  
- [x] `frontend/pages/receipts.html` - Management UI
- [x] `frontend/js/receipts.js` - Frontend logic
- [x] `api/templates/receipts/standard.php` - Receipt template
- [x] `database/receipt_invoice_setup.sql` - Database schema
- [x] `storage/receipts/` - Storage directory
- [x] `storage/invoices/` - Invoice storage

#### ⚠️ Pending Setup
- [ ] Run database setup script
- [ ] Test receipt generation  
- [ ] Configure PDF library (optional)
- [ ] Set up email integration

---

### 🧪 Testing Steps

#### 1. Basic Receipt Generation
```bash
# Test API endpoint
curl -X POST http://localhost/api/receipts/generate \
  -H "Content-Type: application/json" \
  -d '{"transaction_id": 1}'
```

#### 2. View Generated Receipt
```bash
# Check storage directory
ls -la storage/receipts/2025/07/
```

#### 3. Frontend Testing
1. Open receipts.html in browser
2. Check statistics load correctly
3. Test search and filtering
4. Verify receipt preview modal

---

### 🔧 Common Setup Issues

#### Database Connection
- Ensure `api/config.php` has correct DB credentials
- Verify MySQL service is running
- Test connection: `php api/test-connection.php`

#### File Permissions
```bash
# Fix storage permissions
chmod 755 storage/receipts storage/invoices
chown www-data:www-data storage/receipts storage/invoices
```

#### Missing Dependencies
- Ensure PHP 7.4+ with PDO extension
- AdminLTE v3 assets loaded correctly
- Bootstrap Icons CSS available

---

### 📈 Next Steps

#### Production Deployment
1. Run database setup on production server
2. Configure proper file permissions
3. Set up backup for storage directories
4. Test email integration
5. Configure SSL for API endpoints

#### Feature Enhancements  
1. Install PDF library (TCPDF/mPDF)
2. Set up automated email receipts
3. Create member portal access
4. Add advanced reporting features

---

### 📞 Quick Support

#### File Locations
- **Main Service**: `api/services/ReceiptService.php`
- **API Endpoints**: `api/receipts/index.php`  
- **Frontend Page**: `frontend/pages/receipts.html`
- **Database Setup**: `database/receipt_invoice_setup.sql`

#### Common API Calls
```javascript
// Get receipt statistics
fetch('/api/receipts/stats')

// List receipts with filters  
fetch('/api/receipts/receipts?limit=20&transaction_type=membership_fee')

// Generate new receipt
fetch('/api/receipts/generate', {
    method: 'POST',
    body: JSON.stringify({transaction_id: 123})
})

// View specific receipt
fetch('/api/receipts/view/456')
```

---

*Setup Time: ~5 minutes*
*Full Documentation: RECEIPT_INVOICE_SYSTEM_COMPLETE_GUIDE.md*
