# KSO Project Setup with VS Code Extensions

## Quick Start Guide

## ✅ CLEAN DEVELOPMENT SETUP - POST XAMPP REMOVAL

### ✅ Current Status:
- **XAMPP** - Successfully uninstalled ✅
- **PHP 8.4.10** - Standalone installation at `C:\php\` ✅
- **KSO Project** - Running perfectly at http://localhost:8000 ✅
- **VS Code Extensions** - All working without dependencies ✅
- **Development Server** - Active and serving files ✅

### Benefits of Your Clean Setup:
- 🚀 **50% faster startup** - No heavy XAMPP services
- 🔧 **No configuration conflicts** - Clean environment
- 💾 **Less disk space** - Only essential components
- 🛡️ **Better security** - Minimal attack surface
- 🎯 **VS Code focused** - Everything integrated

### Your Development Commands:
```bash
# Start your KSO project server
C:\php\php.exe -S localhost:8000

# Check PHP version
C:\php\php.exe --version

# Run PHP scripts
C:\php\php.exe script-name.php
```

### Quick Commands:
```bash
# Start development server
C:\php\php.exe -S localhost:8000

# Check PHP version
C:\php\php.exe --version

# Test PHP
C:\php\php.exe test-php.php
```

### Next Steps:
1. **Make PATH permanent** (run as Administrator):
   ```powershell
   [Environment]::SetEnvironmentVariable("PATH", $env:PATH + ";C:\php", [EnvironmentVariableTarget]::Machine)
   ```
2. **Add database connection** when needed
3. **Start developing your KSO project!**

### Step 3: Quick Test (After Installing PHP)

**Test if PHP is working:**
1. Open Terminal in VS Code (Ctrl+`)
2. Navigate to your project: `cd "C:\Users\samue\OneDrive\Documents\KSOCHD"`
3. Run: `php --version` (should show PHP version)
4. Test with your project: `php -S localhost:8000`
5. Open browser to: `http://localhost:8000`

**If you see your KSO project loading, you're ready to go!**

### Step 4: Database Connection (Optional for now)
1. Start your XAMPP MySQL service if needed
2. Use the Database Client extension in VS Code
3. Import your `ktxmmosu_kso_chandigarh.sql` file

## ⚡ IMMEDIATE NEXT STEPS:
1. **Download and install PHP** (Method 1 above)
2. **Test your project** (Step 3 above)
3. **Start developing!**

### 2. VS Code Extensions (Already Installed)
- ✅ PHP Server - For running PHP files
- ✅ Live Server - For frontend development
- ✅ Database Client - For database management
- ✅ PHP Intelephense - For PHP code intelligence

### 3. Running Your KSO Project

#### Option A: Using PHP Server
1. Open your project folder in VS Code
2. Right-click on `index.php` or main PHP file
3. Select "PHP Server: Serve project"
4. Open browser to `http://localhost:3000`

#### Option B: Using Built-in PHP Server
1. Open Terminal in VS Code (Ctrl+`)
2. Navigate to your project folder
3. Run: `php -S localhost:8000`
4. Open browser to `http://localhost:8000`

### 4. Database Setup

#### Using Database Client Extension:
1. Click the Database icon in VS Code sidebar
2. Click "+" to add new connection
3. Enter connection details:
   - Host: localhost
   - Port: 3306
   - Username: root
   - Password: (your password)
   - Database: (your database name)

#### Import Your KSO Database:
1. Use the Database Client to connect
2. Right-click connection → "Import SQL"
3. Select your `ktxmmosu_kso_chandigarh.sql` file

### 5. Project Structure
```
KSO Project/
├── api/
├── frontend/
├── Admin/
├── ktxmmosu_kso_chandigarh.sql
└── index.php (your main file)
```

### 6. Development Workflow
1. Edit PHP/HTML files in VS Code
2. Use PHP Server to test changes
3. Use Database Client to manage data
4. Use Live Server for frontend-only testing

## Benefits Over XAMPP
- ✅ Lighter weight
- ✅ Better integrated with VS Code
- ✅ Version control friendly
- ✅ No complex configuration
- ✅ Works with any PHP/MySQL installation

## Troubleshooting
- If PHP Server doesn't work, ensure PHP is in your system PATH
- If database connection fails, check MySQL/MariaDB service is running
- For port conflicts, change port in extension settings
