# KSO Chandigarh - Hosting Deployment Checklist

## Pre-Deployment Setup

### 1. Database Configuration
- [ ] Create MySQL database on your hosting provider
- [ ] Import SQL schema from `/access/database/all_in_one_schema.sql`
- [ ] Update database credentials in `/access/api/config.php`:
  ```php
  $db_config = [
      'host' => 'localhost',
      'dbname' => 'your_actual_database_name',
      'username' => 'your_actual_db_username', 
      'password' => 'your_actual_db_password',
      'charset' => 'utf8mb4'
  ];
  ```

### 2. Configuration Updates
- [ ] Set production flag in `/access/api/config.php`:
  ```php
  $is_production = true;
  ```

### 3. File Permissions
Ensure these directories have write permissions (755 or 775):
- [ ] `/access/storage/`
- [ ] `/access/uploads/`
- [ ] `/access/logs/`

### 4. Admin Login Setup
Create admin user in database:
```sql
INSERT INTO admin_users (username, email, password_hash, name, role, status) 
VALUES ('admin', 'admin@yourdomain.com', '$2y$10$hash_here', 'Administrator', 'super_admin', 'active');
```

## File Upload Structure
```
/public_html/
├── access/
│   ├── admin/frontend/     (Admin interface files)
│   ├── api/               (Backend API files)
│   ├── database/          (SQL files)
│   ├── storage/           (Writable - sessions, cache)
│   ├── uploads/           (Writable - uploaded files)
│   └── logs/              (Writable - error logs)
```

## Testing After Deployment

### 1. Basic Connectivity
- [ ] Access: `https://yourdomain.com/access/admin/frontend/pages/dashboard.html`
- [ ] Check browser console for errors
- [ ] Verify CSS and JS files load correctly

### 2. API Connectivity  
- [ ] Test API endpoint: `https://yourdomain.com/access/api/dashboard.php`
- [ ] Check database connection in hosting control panel

### 3. AdminLTE Interface
- [ ] Verify sidebar navigation works
- [ ] Check responsive design on mobile
- [ ] Test include system loading

### 4. Security
- [ ] Ensure direct PHP file access is blocked
- [ ] Test HTTPS redirects
- [ ] Verify session management

## Common Hosting Issues & Solutions

### CSS/JS Not Loading
- Check file paths are relative (../assets/css/...)
- Verify file permissions (644 for files, 755 for directories)
- Check .htaccess rules if using Apache

### Database Connection Failed
- Verify database credentials
- Check if PDO MySQL extension is enabled
- Ensure database name format matches hosting provider

### Session Issues
- Check if session directory is writable
- Verify cookie settings match domain
- Ensure PHP session extension is enabled

### API Calls Failing
- Check CORS settings in config.php
- Verify API endpoints are accessible
- Check server error logs for PHP errors

## Security Hardening
- [ ] Change default admin credentials
- [ ] Set strong database passwords
- [ ] Enable HTTPS only
- [ ] Regular security updates
- [ ] Monitor error logs

## Performance Optimization
- [ ] Enable gzip compression
- [ ] Set proper cache headers
- [ ] Optimize images and assets
- [ ] Use CDN if needed

## Backup Strategy
- [ ] Regular database backups
- [ ] File system backups
- [ ] Test restore procedures
