<?php
/**
 * Login Endpoint
 * Simplified authentication
 */

define('API_ACCESS', true);
require_once '../../../shared/api/config.php';

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(405, false, 'Method not allowed');
}

// Get JSON input
$input = getJsonInput();
// Fallback for form submissions (e.g., form-encoded or multipart)
if (empty($input) && !empty($_POST)) {
    $input = $_POST;
}
// Map email field to username for form submissions
if (isset($input['email']) && !isset($input['username'])) {
    $input['username'] = $input['email'];
}

// Validate required fields
if (empty($input['username']) || empty($input['password'])) {
    sendResponse(400, false, 'Username and password are required');
}

$username = trim($input['username']);
$password = trim($input['password']);

try {
    // Special development mode for testing without database
    if (!$is_production && ($username === 'admin' && $password === 'admin123')) {
        // Mock admin data for development
        $admin = [
            'id' => 1,
            'kso_id' => 'KSO001',
            'first_name' => 'Admin',
            'last_name' => 'User',
            'username' => 'admin',
            'email' => 'admin@example.com',
            'role' => 'admin',
            'status' => 'active'
        ];
    } elseif (!$is_production && ($username === 'haominthang' && $password === 'password')) {
        // Mock another user for development
        $admin = [
            'id' => 2,
            'kso_id' => 'KSO002',
            'first_name' => 'Hao Min',
            'last_name' => 'Thang',
            'username' => 'haominthang',
            'email' => 'haominthang@example.com',
            'role' => 'admin',
            'status' => 'active'
        ];
    } else {
        // Only try database if we're not using mock data or in production
        try {
        // Ensure database connection is available
        if ($pdo === null) {
            sendResponse(500, false, 'Service temporarily unavailable');
        }
        // Admin lookup with username, email, or KSO ID
            $sql = "SELECT id, kso_id, first_name, last_name, username, email, password_hash, role, status 
                    FROM admins 
                    WHERE (username = ? OR email = ? OR kso_id = ?) AND status = 'active'";
            
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$username, $username, $username]);
            $admin = $stmt->fetch();
            
            if (!$admin) {
                sendResponse(401, false, 'Invalid username or password');
            }
            
            // Password verification: detect hash type
            if (strpos($admin['password_hash'], '$') === 0) {
                // PHP password_hash format
                $isValidPassword = password_verify($password, $admin['password_hash']);
            } else {
                // Legacy MD5 hashes
                $isValidPassword = (md5($password) === $admin['password_hash']);
            }
            // If legacy MD5 matched, rehash and update to stronger algorithm
            if ($isValidPassword && strpos($admin['password_hash'], '$') !== 0) {
                $newHash = password_hash($password, PASSWORD_DEFAULT);
                $updateStmt = $pdo->prepare("UPDATE admins SET password_hash = ? WHERE id = ?");
                $updateStmt->execute([$newHash, $admin['id']]);
                // Update local copy for session
                $admin['password_hash'] = $newHash;
            }
            
            if (!$isValidPassword) {
                sendResponse(401, false, 'Invalid username or password');
            }
        } catch (Exception $e) {
            // If we're in development mode, we can still try fallback logins
            if (!$is_production && (($username === 'admin' && $password === 'admin123') || 
                                   ($username === 'haominthang' && $password === 'password'))) {
                // Let it proceed to the session setup with mock data from above
            } else {
                // Otherwise, return an error
                logError('Database error in login: ' . $e->getMessage());
                sendResponse(500, false, 'Service temporarily unavailable');
            }
        }
    }
    
    // Start session and store admin data
    startSession();
    $_SESSION['admin_logged_in'] = true;
    $_SESSION['admin_id'] = $admin['id'];
    $_SESSION['admin_username'] = $admin['username'];
    $_SESSION['admin_email'] = $admin['email'];
    $_SESSION['admin_name'] = trim($admin['first_name'] . ' ' . $admin['last_name']);
    $_SESSION['admin_role'] = $admin['role'];
    $_SESSION['login_time'] = time();
    
    // Log activity
    logActivity($admin['id'], 'login', 'Successful login', [
        'username' => $admin['username'],
        'ip' => $_SERVER['REMOTE_ADDR'] ?? 'unknown'
    ]);
    
    // Return success response
    sendResponse(200, true, 'Login successful', [
        'admin' => [
            'id' => $admin['id'],
            'username' => $admin['username'],
            'email' => $admin['email'],
            'name' => trim($admin['first_name'] . ' ' . $admin['last_name']),
            'role' => $admin['role']
        ]
    ]);
    
} catch (Exception $e) {
    logError('Login error: ' . $e->getMessage());
    sendResponse(500, false, 'Login failed');
}
?>


