<?php
/**
 * Logout Endpoint
 * Simplified logout
 */

define('API_ACCESS', true);
require_once '../../../shared/api/config.php';

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(405, false, 'Method not allowed');
}

try {
    startSession();
    
    // Log activity before destroying session
    if (isLoggedIn()) {
        $admin = getCurrentAdmin();
        if ($admin) {
            logActivity($admin['id'], 'logout', 'User logged out');
        }
    }
    
    // Destroy session
    session_destroy();
    
    // Clear session cookie
    if (isset($_COOKIE[session_name()])) {
        setcookie(session_name(), '', time() - 3600, '/');
    }
    
    sendResponse(200, true, 'Logout successful');
    
} catch (Exception $e) {
    logError('Logout error: ' . $e->getMessage());
    sendResponse(500, false, 'Logout failed');
}
?>


