<?php
/**
 * Session Check Endpoint
 * Simplified session management
 */

define('API_ACCESS', true);
require_once '../../../shared/api/config.php';

// Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendResponse(405, false, 'Method not allowed');
}

try {
    $admin = getCurrentAdmin();
    
    if ($admin) {
        sendResponse(200, true, 'Session active', [
            'logged_in' => true,
            'admin' => $admin
        ]);
    } else {
        sendResponse(200, true, 'No active session', [
            'logged_in' => false
        ]);
    }
    
} catch (Exception $e) {
    logError('Session check error: ' . $e->getMessage());
    sendResponse(500, false, 'Session check failed');
}
?>


