<?php
/**
 * Session Verification Endpoint
 */

define('API_ACCESS', true);
require_once '../../../shared/api/config.php';

// Only allow GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    sendResponse(405, false, 'Method not allowed');
}

try {
    // Check if user is logged in
    if (isLoggedIn()) {
        $admin = getCurrentAdmin();
        sendResponse(200, true, 'Session valid', [
            'admin' => $admin,
            'session_id' => session_id()
        ]);
    } else {
        sendResponse(401, false, 'Session invalid or expired');
    }
} catch (Exception $e) {
    error_log("Error in verify.php: " . $e->getMessage());
    sendResponse(500, false, 'Internal server error');
}
?>
