<?php
// Define API access constant
define('API_ACCESS', true);

require_once '../../../shared/api/config.php';

$method = $_SERVER['REQUEST_METHOD'];

try {
    switch ($method) {
        case 'GET':
            getMembersStats();
            break;
        default:
            ApiResponse::error('Method not allowed', 405);
    }
} catch (Exception $e) {
    ApiResponse::error('Internal server error: ' . $e->getMessage(), 500);
}

function getMembersStats() {
    global $pdo;
    
    try {
        // Get comprehensive member statistics
        $stmt = $pdo->query("
            SELECT 
                COUNT(*) as total_members,
                SUM(CASE WHEN approval_status = 'approved' THEN 1 ELSE 0 END) as approved_members,
                SUM(CASE WHEN approval_status = 'pending' THEN 1 ELSE 0 END) as pending_members,
                SUM(CASE WHEN approval_status = 'rejected' THEN 1 ELSE 0 END) as rejected_members,
                SUM(CASE WHEN approval_status = 'under_review' THEN 1 ELSE 0 END) as under_review_members,
                SUM(CASE WHEN membership_type = 'Individual' THEN 1 ELSE 0 END) as individual_members,
                SUM(CASE WHEN membership_type = 'Family' THEN 1 ELSE 0 END) as family_members,
                SUM(CASE WHEN status = 'active' THEN 1 ELSE 0 END) as active_members,
                SUM(CASE WHEN status = 'inactive' THEN 1 ELSE 0 END) as inactive_members,
                SUM(CASE WHEN status = 'suspended' THEN 1 ELSE 0 END) as suspended_members,
                SUM(CASE WHEN DATE(created_at) = CURDATE() THEN 1 ELSE 0 END) as today_registrations,
                SUM(CASE WHEN DATE(created_at) >= DATE_SUB(CURDATE(), INTERVAL 7 DAY) THEN 1 ELSE 0 END) as week_registrations,
                SUM(CASE WHEN DATE(created_at) >= DATE_SUB(CURDATE(), INTERVAL 30 DAY) THEN 1 ELSE 0 END) as month_registrations
            FROM members
        ");
        
        $stats = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Convert to integers
        foreach ($stats as $key => $value) {
            $stats[$key] = (int)$value;
        }
        
        // Get pending assignment count (members assigned to current admin if any)
        $currentAdminId = ApiAuth::getCurrentAdminId();
        $stats['assigned_to_me'] = 0;
        if ($currentAdminId) {
            $stmt = $pdo->prepare("SELECT COUNT(*) as assigned FROM members WHERE assigned_to = ? AND approval_status = 'pending'");
            $stmt->execute([$currentAdminId]);
            $stats['assigned_to_me'] = (int)$stmt->fetchColumn();
        }
        
        ApiResponse::success($stats, 'Members statistics retrieved successfully');
        
    } catch (Exception $e) {
        error_log("Error in getMembersStats: " . $e->getMessage());
        ApiResponse::error('Failed to retrieve statistics: ' . $e->getMessage(), 500);
    }
}
?>


