/**
 * KSO Chandigarh Include Loader
 * Loads HTML includes into pages - optimized for AdminLTE
 * Note: CSS files should be in the <head> section, not in includes
 */

class IncludeLoader {
    static async loadIncludes() {
        const includes = document.querySelectorAll('[data-include]');
        
        for (const element of includes) {
            const includePath = element.getAttribute('data-include');
            const basePath = '../includes/';
            
            try {
                const response = await fetch(basePath + includePath);
                if (response.ok) {
                    const content = await response.text();
                    element.innerHTML = content;
                    
                    // Execute any scripts in the loaded content
                    const scripts = element.querySelectorAll('script');
                    scripts.forEach(script => {
                        const newScript = document.createElement('script');
                        if (script.src) {
                            newScript.src = script.src;
                        } else {
                            newScript.textContent = script.textContent;
                        }
                        document.head.appendChild(newScript);
                    });
                    
                    // Initialize AdminLTE components for loaded content
                    if (window.AdminLTE && typeof window.AdminLTE.init === 'function') {
                        window.AdminLTE.init();
                    }
                } else {
                    console.error(`Failed to load include: ${includePath}`);
                    element.innerHTML = `<!-- Failed to load: ${includePath} -->`;
                }
            } catch (error) {
                console.error(`Error loading include ${includePath}:`, error);
                element.innerHTML = `<!-- Error loading: ${includePath} -->`;
            }
        }
    }
}

// Auto-load includes when DOM is ready
document.addEventListener('DOMContentLoaded', function() {
    IncludeLoader.loadIncludes();
});

// Export for manual use
window.IncludeLoader = IncludeLoader;
