<?php
/**
 * KSO Chandigarh Authentication - Hosting Site Style
 * Based on the hosting environment's authentication method
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once '../config.php';

// Hosting-style authentication function
function hostingStyleAuth($username, $password) {
    // Development mode credentials (same as hosting site)
    $dev_credentials = [
        'admin' => 'admin123',
        'haominthang' => 'password'
    ];
    
    // Try development mode first (hosting site approach)
    if (isset($dev_credentials[$username]) && $dev_credentials[$username] === $password) {
        return [
            'success' => true,
            'user' => [
                'id' => 1,
                'username' => $username,
                'full_name' => ucfirst($username),
                'role' => 'admin',
                'auth_mode' => 'development'
            ]
        ];
    }
    
    // Try database authentication with hosting-style hash verification
    try {
        $pdo = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
            ]
        );
        
        $stmt = $pdo->prepare("SELECT * FROM admins WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch();
        
        if ($user) {
            $stored_hash = $user['password_hash'];
            
            // Hosting site uses multiple verification methods
            $auth_success = false;
            
            // Method 1: Modern password_hash verification
            if (password_verify($password, $stored_hash)) {
                $auth_success = true;
            }
            
            // Method 2: Legacy MD5 verification (hosting site compatibility)
            else if (md5($password) === $stored_hash) {
                $auth_success = true;
                
                // Auto-upgrade to secure hash (hosting site behavior)
                $new_hash = password_hash($password, PASSWORD_DEFAULT, ['cost' => 12]);
                $update_stmt = $pdo->prepare("UPDATE admins SET password_hash = ? WHERE id = ?");
                $update_stmt->execute([$new_hash, $user['id']]);
            }
            
            // Method 3: Test common hosting patterns
            else {
                $test_patterns = [
                    md5($password . 'kso'),
                    md5($password . 'chandigarh'),
                    md5($password . 'kso_chandigarh'),
                    md5($username . $password),
                    md5($password . '123'),
                    md5($password . '2024'),
                    md5($password . '2025')
                ];
                
                foreach ($test_patterns as $pattern) {
                    if ($pattern === $stored_hash) {
                        $auth_success = true;
                        
                        // Auto-upgrade to secure hash
                        $new_hash = password_hash($password, PASSWORD_DEFAULT, ['cost' => 12]);
                        $update_stmt = $pdo->prepare("UPDATE admins SET password_hash = ? WHERE id = ?");
                        $update_stmt->execute([$new_hash, $user['id']]);
                        break;
                    }
                }
            }
            
            if ($auth_success) {
                return [
                    'success' => true,
                    'user' => [
                        'id' => $user['id'],
                        'username' => $user['username'],
                        'full_name' => $user['full_name'] ?? ucfirst($username),
                        'role' => $user['role'] ?? 'admin',
                        'auth_mode' => 'database'
                    ]
                ];
            }
        }
        
    } catch (PDOException $e) {
        // Database error - fall back to development mode
        if (isset($dev_credentials[$username]) && $dev_credentials[$username] === $password) {
            return [
                'success' => true,
                'user' => [
                    'id' => 1,
                    'username' => $username,
                    'full_name' => ucfirst($username),
                    'role' => 'admin',
                    'auth_mode' => 'development_fallback'
                ]
            ];
        }
    }
    
    return ['success' => false, 'message' => 'Invalid credentials'];
}

// Handle authentication request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $username = $input['username'] ?? '';
    $password = $input['password'] ?? '';
    
    if (empty($username) || empty($password)) {
        echo json_encode(['success' => false, 'message' => 'Username and password required']);
        exit;
    }
    
    $result = hostingStyleAuth($username, $password);
    
    if ($result['success']) {
        // Start session (hosting site style)
        session_start();
        $_SESSION['admin_id'] = $result['user']['id'];
        $_SESSION['admin_username'] = $result['user']['username'];
        $_SESSION['admin_role'] = $result['user']['role'];
        $_SESSION['auth_mode'] = $result['user']['auth_mode'];
        $_SESSION['login_time'] = time();
        
        // Log successful login
        error_log("KSO Admin Login: {$username} authenticated via {$result['user']['auth_mode']}");
        
        echo json_encode([
            'success' => true,
            'message' => 'Authentication successful',
            'user' => $result['user'],
            'redirect' => '../dashboard.php'
        ]);
    } else {
        echo json_encode($result);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'POST method required']);
}
?>
