<?php
require_once '../config.php';

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Require authentication
require_auth();

try {
    $stats = [
        'total_documents' => 0,
        'total_size' => 0,
        'categories' => [],
        'document_types' => [],
        'recent_documents' => [],
        'uploads_by_month' => []
    ];
    
    // Get total documents and size
    $stmt = $pdo->prepare("SELECT COUNT(*) as total, SUM(file_size) as total_size FROM documents");
    $stmt->execute();
    $totals = $stmt->fetch(PDO::FETCH_ASSOC);
    
    $stats['total_documents'] = $totals['total'] ?? 0;
    $stats['total_size'] = $totals['total_size'] ?? 0;
    
    // Get documents by category
    $stmt = $pdo->prepare("
        SELECT 
            category,
            COUNT(*) as count,
            SUM(file_size) as size
        FROM documents 
        GROUP BY category
        ORDER BY count DESC
    ");
    $stmt->execute();
    $stats['categories'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get documents by type
    $stmt = $pdo->prepare("
        SELECT 
            document_type,
            COUNT(*) as count
        FROM documents 
        GROUP BY document_type
        ORDER BY count DESC
    ");
    $stmt->execute();
    $stats['document_types'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get recent documents (last 10)
    $stmt = $pdo->prepare("
        SELECT 
            id, title, category, document_type, file_name, file_size, 
            is_public, uploaded_by, created_at
        FROM documents 
        ORDER BY created_at DESC 
        LIMIT 10
    ");
    $stmt->execute();
    $stats['recent_documents'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get uploads by month (last 12 months)
    $stmt = $pdo->prepare("
        SELECT 
            DATE_FORMAT(created_at, '%Y-%m') as month,
            COUNT(*) as count,
            SUM(file_size) as size
        FROM documents 
        WHERE created_at >= DATE_SUB(NOW(), INTERVAL 12 MONTH)
        GROUP BY DATE_FORMAT(created_at, '%Y-%m')
        ORDER BY month
    ");
    $stmt->execute();
    $stats['uploads_by_month'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'data' => $stats
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>
