<?php
// Define API access constant
define('API_ACCESS', true);

// Include configuration and authentication files
require_once '../config.php';
require_once '../auth/authenticate.php';

// Require admin authentication
requireAuth();

// Get the request method
$method = $_SERVER['REQUEST_METHOD'];

// Process the request
try {
    if ($method === 'GET') {
        getReceiptStats();
    } else {
        sendResponse(405, false, 'Method not allowed');
    }
} catch (Exception $e) {
    // Log and send error response
    error_log("Error in receipts stats API: " . $e->getMessage());
    sendResponse(500, false, 'Internal server error: ' . $e->getMessage());
}

/**
 * Calculate and return receipt statistics
 */
function getReceiptStats() {
    global $pdo;
    
    try {
        // Total receipts
        $totalReceiptsStmt = $pdo->query("SELECT COUNT(*) FROM receipts");
        $totalReceipts = $totalReceiptsStmt->fetchColumn();
        
        // Today's receipts
        $todayReceiptsStmt = $pdo->prepare("SELECT COUNT(*) FROM receipts WHERE DATE(receipt_date) = CURDATE()");
        $todayReceiptsStmt->execute();
        $todayReceipts = $todayReceiptsStmt->fetchColumn();
        
        // This month's receipts
        $thisMonthReceiptsStmt = $pdo->prepare("SELECT COUNT(*) FROM receipts WHERE YEAR(receipt_date) = YEAR(CURDATE()) AND MONTH(receipt_date) = MONTH(CURDATE())");
        $thisMonthReceiptsStmt->execute();
        $thisMonthReceipts = $thisMonthReceiptsStmt->fetchColumn();
        
        // Total amount from receipts
        $totalAmountStmt = $pdo->query("SELECT SUM(amount) FROM receipts");
        $totalAmount = $totalAmountStmt->fetchColumn();
        
        // Compile stats into an array
        $stats = [
            'total_receipts' => (int)$totalReceipts,
            'today_receipts' => (int)$todayReceipts,
            'this_month_receipts' => (int)$thisMonthReceipts,
            'total_amount' => (float)$totalAmount
        ];
        
        sendResponse(200, true, 'Receipt statistics retrieved successfully', $stats);
        
    } catch (Exception $e) {
        error_log("Error getting receipt stats: " . $e->getMessage());
        sendResponse(500, false, 'Failed to retrieve receipt statistics');
    }
}
?>
