<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice - <?php echo $invoice['invoice_number']; ?></title>
    <style>
        @page {
            margin: 20mm;
            size: A4;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 14px;
            line-height: 1.6;
            color: #333;
            background: #fff;
        }
        
        .invoice-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            background: #fff;
        }
        
        .header {
            border-bottom: 3px solid #dc3545;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        
        .organization-info {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 15px;
        }
        
        .org-logo {
            width: 80px;
            height: 80px;
            background: #dc3545;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 24px;
        }
        
        .org-details h1 {
            font-size: 28px;
            color: #dc3545;
            margin-bottom: 5px;
        }
        
        .org-details p {
            margin: 2px 0;
            color: #666;
        }
        
        .invoice-title {
            text-align: center;
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
        }
        
        .invoice-title h2 {
            font-size: 28px;
            color: #dc3545;
            margin-bottom: 5px;
        }
        
        .invoice-number {
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
        
        .invoice-details {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
            margin-bottom: 30px;
        }
        
        .detail-section h3 {
            color: #dc3545;
            border-bottom: 2px solid #e9ecef;
            padding-bottom: 10px;
            margin-bottom: 15px;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            padding: 5px 0;
        }
        
        .detail-label {
            font-weight: 600;
            color: #555;
        }
        
        .detail-value {
            color: #333;
        }
        
        .status-pending {
            background: #fff3cd;
            color: #856404;
            padding: 10px 20px;
            border-radius: 25px;
            font-weight: bold;
            display: inline-block;
            margin: 10px 0;
        }
        
        .status-paid {
            background: #d4edda;
            color: #155724;
            padding: 10px 20px;
            border-radius: 25px;
            font-weight: bold;
            display: inline-block;
            margin: 10px 0;
        }
        
        .status-overdue {
            background: #f8d7da;
            color: #721c24;
            padding: 10px 20px;
            border-radius: 25px;
            font-weight: bold;
            display: inline-block;
            margin: 10px 0;
        }
        
        .items-table {
            width: 100%;
            border-collapse: collapse;
            background: #fff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            margin: 30px 0;
        }
        
        .items-table th {
            background: #dc3545;
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: 600;
        }
        
        .items-table td {
            padding: 15px;
            border-bottom: 1px solid #e9ecef;
        }
        
        .items-table tr:last-child td {
            border-bottom: none;
        }
        
        .amount-section {
            background: linear-gradient(135deg, #dc3545, #b52d3c);
            color: white;
            padding: 25px;
            border-radius: 8px;
            margin: 30px 0;
            text-align: right;
        }
        
        .amount-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            padding: 5px 0;
        }
        
        .total-amount {
            border-top: 2px solid rgba(255,255,255,0.3);
            padding-top: 15px;
            margin-top: 15px;
        }
        
        .total-amount .amount-value {
            font-size: 28px;
            font-weight: bold;
        }
        
        .payment-info {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        
        .payment-methods {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin: 20px 0;
        }
        
        .payment-method {
            background: #fff;
            padding: 15px;
            border-radius: 8px;
            border: 1px solid #e9ecef;
        }
        
        .due-date-warning {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            color: #856404;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            text-align: center;
        }
        
        .terms-conditions {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin: 30px 0;
        }
        
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 2px solid #e9ecef;
            text-align: center;
        }
        
        .footer-text {
            color: #666;
            font-size: 12px;
            margin-bottom: 10px;
        }
        
        @media print {
            .no-print {
                display: none;
            }
            
            body {
                font-size: 12px;
            }
            
            .invoice-container {
                padding: 0;
                margin: 0;
                max-width: none;
            }
        }
    </style>
</head>
<body>
    <div class="invoice-container">
        <!-- Header Section -->
        <div class="header">
            <div class="organization-info">
                <div class="org-logo">KSO</div>
                <div class="org-details">
                    <h1>Kashmiri Students Organization</h1>
                    <p><strong>Chandigarh Chapter</strong></p>
                    <p>📍 Chandigarh, India</p>
                    <p>📞 +91-XXXXX-XXXXX | 📧 info@ksochandigarh.com</p>
                    <p>🌐 www.ksochandigarh.com</p>
                </div>
                <div style="text-align: right;">
                    <p><strong>GST No:</strong> N/A</p>
                    <p><strong>PAN No:</strong> N/A</p>
                </div>
            </div>
        </div>

        <!-- Invoice Title -->
        <div class="invoice-title">
            <h2>INVOICE</h2>
            <div class="invoice-number">Invoice No: <?php echo $invoice['invoice_number']; ?></div>
            <div class="<?php echo 'status-' . $invoice['status']; ?>">
                <?php echo strtoupper($invoice['status']); ?>
            </div>
        </div>

        <!-- Invoice Details -->
        <div class="invoice-details">
            <!-- Bill To -->
            <div class="detail-section">
                <h3>📋 Bill To</h3>
                <div class="detail-row">
                    <span class="detail-label">Name:</span>
                    <span class="detail-value"><?php echo $invoice['first_name'] . ' ' . $invoice['last_name']; ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">KSO ID:</span>
                    <span class="detail-value"><?php echo $invoice['kso_id']; ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Email:</span>
                    <span class="detail-value"><?php echo $invoice['email']; ?></span>
                </div>
                <?php if (!empty($invoice['address'])): ?>
                <div class="detail-row">
                    <span class="detail-label">Address:</span>
                    <span class="detail-value"><?php echo $invoice['address']; ?></span>
                </div>
                <?php endif; ?>
            </div>

            <!-- Invoice Information -->
            <div class="detail-section">
                <h3>📅 Invoice Information</h3>
                <div class="detail-row">
                    <span class="detail-label">Invoice Date:</span>
                    <span class="detail-value"><?php echo date('d/m/Y', strtotime($invoice['created_at'])); ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Due Date:</span>
                    <span class="detail-value" style="<?php echo (strtotime($invoice['due_date']) < time()) ? 'color: #dc3545; font-weight: bold;' : ''; ?>">
                        <?php echo date('d/m/Y', strtotime($invoice['due_date'])); ?>
                    </span>
                </div>
                <?php if ($invoice['status'] === 'paid'): ?>
                <div class="detail-row">
                    <span class="detail-label">Paid Date:</span>
                    <span class="detail-value"><?php echo date('d/m/Y', strtotime($invoice['paid_date'])); ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Paid Amount:</span>
                    <span class="detail-value">₹<?php echo number_format($invoice['paid_amount'], 2); ?></span>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Due Date Warning -->
        <?php if ($invoice['status'] === 'pending' && strtotime($invoice['due_date']) < time()): ?>
        <div class="due-date-warning">
            <strong>⚠️ OVERDUE NOTICE</strong><br>
            This invoice was due on <?php echo date('d/m/Y', strtotime($invoice['due_date'])); ?>. 
            Please make payment immediately to avoid late fees.
        </div>
        <?php elseif ($invoice['status'] === 'pending'): ?>
        <div class="due-date-warning" style="background: #d1ecf1; border-color: #bee5eb; color: #0c5460;">
            <strong>💡 PAYMENT DUE</strong><br>
            Payment is due by <?php echo date('d/m/Y', strtotime($invoice['due_date'])); ?>
        </div>
        <?php endif; ?>

        <!-- Items Table -->
        <div>
            <h3 style="color: #dc3545; margin-bottom: 15px;">📋 Invoice Items</h3>
            <table class="items-table">
                <thead>
                    <tr>
                        <th style="width: 50%;">Description</th>
                        <th style="width: 15%;">Quantity</th>
                        <th style="width: 15%;">Rate</th>
                        <th style="width: 20%;">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $items = json_decode($invoice['items'], true);
                    $subtotal = 0;
                    foreach ($items as $item): 
                        $item_total = $item['quantity'] * $item['rate'];
                        $subtotal += $item_total;
                    ?>
                    <tr>
                        <td>
                            <strong><?php echo $item['description']; ?></strong>
                            <?php if (!empty($item['details'])): ?>
                                <br><small style="color: #666;"><?php echo $item['details']; ?></small>
                            <?php endif; ?>
                        </td>
                        <td><?php echo $item['quantity']; ?></td>
                        <td>₹<?php echo number_format($item['rate'], 2); ?></td>
                        <td><strong>₹<?php echo number_format($item_total, 2); ?></strong></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Amount Section -->
        <div class="amount-section">
            <div class="amount-row">
                <span>Subtotal:</span>
                <span>₹<?php echo number_format($subtotal, 2); ?></span>
            </div>
            
            <?php 
            $tax_rate = 0; // No tax for educational organization
            $tax_amount = $subtotal * ($tax_rate / 100);
            $discount = 0; // No discount for now
            ?>
            
            <?php if ($tax_amount > 0): ?>
            <div class="amount-row">
                <span>Tax (<?php echo $tax_rate; ?>%):</span>
                <span>₹<?php echo number_format($tax_amount, 2); ?></span>
            </div>
            <?php endif; ?>
            
            <?php if ($discount > 0): ?>
            <div class="amount-row">
                <span>Discount:</span>
                <span>-₹<?php echo number_format($discount, 2); ?></span>
            </div>
            <?php endif; ?>
            
            <div class="total-amount">
                <div class="amount-row">
                    <span style="font-size: 20px; font-weight: bold;">Total Amount:</span>
                    <span class="amount-value">₹<?php echo number_format($invoice['total_amount'], 2); ?></span>
                </div>
            </div>
        </div>

        <!-- Payment Information -->
        <?php if ($invoice['status'] === 'pending'): ?>
        <div class="payment-info">
            <h4 style="color: #dc3545; margin-bottom: 15px;">💳 Payment Methods</h4>
            <div class="payment-methods">
                <div class="payment-method">
                    <h5>🏦 Bank Transfer</h5>
                    <p><strong>Account Name:</strong> KSO Chandigarh</p>
                    <p><strong>Account No:</strong> 1234567890</p>
                    <p><strong>IFSC Code:</strong> SBIN0001234</p>
                    <p><strong>Bank:</strong> State Bank of India</p>
                </div>
                <div class="payment-method">
                    <h5>📱 UPI Payment</h5>
                    <p><strong>UPI ID:</strong> ksochandigarh@paytm</p>
                    <p><strong>QR Code:</strong> Available at office</p>
                    <p><strong>Mobile:</strong> +91-XXXXX-XXXXX</p>
                    <p><small>Please mention invoice number in payment reference</small></p>
                </div>
            </div>
            <p style="background: #e7f3ff; padding: 10px; border-radius: 5px; margin-top: 15px;">
                <strong>Note:</strong> Please include your Invoice Number (<?php echo $invoice['invoice_number']; ?>) in the payment reference for faster processing.
            </p>
        </div>
        <?php endif; ?>

        <!-- Terms and Conditions -->
        <div class="terms-conditions">
            <h4 style="color: #dc3545; margin-bottom: 10px;">📋 Terms & Conditions</h4>
            <ul style="margin-left: 20px; line-height: 1.8;">
                <li>Payment is due within 30 days of invoice date</li>
                <li>Late payments may incur additional charges</li>
                <li>Please ensure your payment includes the invoice number for reference</li>
                <li>For any queries, contact us at info@ksochandigarh.com</li>
                <li>This invoice is valid for 90 days from the date of issue</li>
            </ul>
        </div>

        <!-- Footer -->
        <div class="footer">
            <div class="footer-text">
                <p><strong>Thank you for your business!</strong></p>
                <p>This is a computer-generated invoice.</p>
                <p>For any queries regarding this invoice, please contact us at info@ksochandigarh.com</p>
                <p style="margin-top: 15px; font-size: 10px; color: #999;">
                    Generated on <?php echo date('d/m/Y H:i:s'); ?> | 
                    Invoice ID: <?php echo $invoice['invoice_number']; ?> | 
                    KSO Chandigarh Management System
                </p>
            </div>
        </div>
    </div>

    <script>
        // Auto-print functionality (optional)
        window.onload = function() {
            // Uncomment the line below to auto-print
            // window.print();
        };
    </script>
</body>
</html>
