<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt - <?php echo $transaction['receipt_number']; ?></title>
    <style>
        @page {
            margin: 20mm;
            size: A4;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 14px;
            line-height: 1.6;
            color: #333;
            background: #fff;
        }
        
        .receipt-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            background: #fff;
        }
        
        .header {
            border-bottom: 3px solid #007bff;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        
        .organization-info {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 15px;
        }
        
        .org-logo {
            width: 80px;
            height: 80px;
            background: #007bff;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 24px;
        }
        
        .org-details h1 {
            font-size: 28px;
            color: #007bff;
            margin-bottom: 5px;
        }
        
        .org-details p {
            margin: 2px 0;
            color: #666;
        }
        
        .receipt-title {
            text-align: center;
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
        }
        
        .receipt-title h2 {
            font-size: 24px;
            color: #007bff;
            margin-bottom: 5px;
        }
        
        .receipt-number {
            font-size: 16px;
            font-weight: bold;
            color: #333;
        }
        
        .receipt-details {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
            margin-bottom: 30px;
        }
        
        .detail-section h3 {
            color: #007bff;
            border-bottom: 2px solid #e9ecef;
            padding-bottom: 10px;
            margin-bottom: 15px;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            padding: 5px 0;
        }
        
        .detail-label {
            font-weight: 600;
            color: #555;
        }
        
        .detail-value {
            color: #333;
        }
        
        .payment-info {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        
        .amount-section {
            text-align: center;
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
            padding: 25px;
            border-radius: 8px;
            margin: 30px 0;
        }
        
        .amount-label {
            font-size: 16px;
            margin-bottom: 10px;
            opacity: 0.9;
        }
        
        .amount-value {
            font-size: 36px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        
        .amount-words {
            font-size: 14px;
            opacity: 0.9;
            font-style: italic;
        }
        
        .transaction-details {
            margin: 30px 0;
        }
        
        .transaction-table {
            width: 100%;
            border-collapse: collapse;
            background: #fff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        
        .transaction-table th {
            background: #007bff;
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: 600;
        }
        
        .transaction-table td {
            padding: 15px;
            border-bottom: 1px solid #e9ecef;
        }
        
        .transaction-table tr:last-child td {
            border-bottom: none;
        }
        
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 2px solid #e9ecef;
            text-align: center;
        }
        
        .footer-text {
            color: #666;
            font-size: 12px;
            margin-bottom: 10px;
        }
        
        .signature-section {
            display: flex;
            justify-content: space-between;
            margin-top: 40px;
            padding-top: 20px;
        }
        
        .signature-box {
            text-align: center;
            width: 200px;
        }
        
        .signature-line {
            border-top: 1px solid #333;
            margin-top: 50px;
            padding-top: 5px;
            font-size: 12px;
            color: #666;
        }
        
        .qr-code {
            float: right;
            width: 80px;
            height: 80px;
            background: #f8f9fa;
            border: 1px solid #ddd;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 10px;
            color: #666;
        }
        
        .status-paid {
            background: #d4edda;
            color: #155724;
            padding: 10px 20px;
            border-radius: 25px;
            font-weight: bold;
            display: inline-block;
            margin: 10px 0;
        }
        
        @media print {
            .no-print {
                display: none;
            }
            
            body {
                font-size: 12px;
            }
            
            .receipt-container {
                padding: 0;
                margin: 0;
                max-width: none;
            }
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <!-- Header Section -->
        <div class="header">
            <div class="organization-info">
                <div class="org-logo">KSO</div>
                <div class="org-details">
                    <h1><?php echo $transaction['org_name'] ?? 'Kashmiri Students Organization'; ?></h1>
                    <p><strong>Chandigarh Chapter</strong></p>
                    <p>📍 Chandigarh, India</p>
                    <p>📞 +91-XXXXX-XXXXX | 📧 info@ksochandigarh.com</p>
                    <p>🌐 www.ksochandigarh.com</p>
                </div>
                <div class="qr-code">
                    QR Code<br>
                    (Verify)
                </div>
            </div>
        </div>

        <!-- Receipt Title -->
        <div class="receipt-title">
            <h2>PAYMENT RECEIPT</h2>
            <div class="receipt-number">Receipt No: <?php echo $transaction['receipt_number']; ?></div>
            <div class="status-paid">✅ PAID</div>
        </div>

        <!-- Receipt Details -->
        <div class="receipt-details">
            <!-- Member Information -->
            <div class="detail-section">
                <h3>👤 Member Information</h3>
                <div class="detail-row">
                    <span class="detail-label">Name:</span>
                    <span class="detail-value"><?php echo $transaction['first_name'] . ' ' . $transaction['last_name']; ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">KSO ID:</span>
                    <span class="detail-value"><?php echo $transaction['kso_id']; ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Email:</span>
                    <span class="detail-value"><?php echo $transaction['email']; ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Phone:</span>
                    <span class="detail-value"><?php echo $transaction['phone'] ?? 'N/A'; ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Membership:</span>
                    <span class="detail-value"><?php echo ucfirst($transaction['membership_type']); ?></span>
                </div>
            </div>

            <!-- Payment Information -->
            <div class="detail-section">
                <h3>💳 Payment Information</h3>
                <div class="detail-row">
                    <span class="detail-label">Payment Date:</span>
                    <span class="detail-value"><?php echo date('d/m/Y', strtotime($transaction['payment_date'])); ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Payment Method:</span>
                    <span class="detail-value"><?php echo ucfirst($transaction['payment_method']); ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Transaction Type:</span>
                    <span class="detail-value"><?php echo ucwords(str_replace('_', ' ', $transaction['transaction_type'])); ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Session Year:</span>
                    <span class="detail-value"><?php echo $transaction['session_year'] ?? date('Y'); ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Processed By:</span>
                    <span class="detail-value"><?php echo $transaction['processed_by_name'] ?? 'Admin'; ?></span>
                </div>
            </div>
        </div>

        <!-- Amount Section -->
        <div class="amount-section">
            <div class="amount-label">Total Amount Paid</div>
            <div class="amount-value">₹<?php echo number_format($transaction['amount'], 2); ?></div>
            <div class="amount-words">
                <?php 
                // Convert amount to words (simplified)
                $amount_words = "Rupees " . ucwords(numberToWords($transaction['amount'])) . " Only";
                echo $amount_words;
                ?>
            </div>
        </div>

        <!-- Transaction Details -->
        <div class="transaction-details">
            <h3 style="color: #007bff; margin-bottom: 15px;">📋 Transaction Details</h3>
            <table class="transaction-table">
                <thead>
                    <tr>
                        <th style="width: 50%;">Description</th>
                        <th style="width: 20%;">Type</th>
                        <th style="width: 15%;">Session</th>
                        <th style="width: 15%;">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>
                            <strong><?php echo $transaction['description'] ?: ucwords(str_replace('_', ' ', $transaction['transaction_type'])); ?></strong>
                            <?php if (!empty($transaction['notes'])): ?>
                                <br><small style="color: #666;"><?php echo $transaction['notes']; ?></small>
                            <?php endif; ?>
                        </td>
                        <td><?php echo ucwords(str_replace('_', ' ', $transaction['transaction_type'])); ?></td>
                        <td><?php echo $transaction['session_year'] ?? date('Y'); ?></td>
                        <td><strong>₹<?php echo number_format($transaction['amount'], 2); ?></strong></td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Payment Info Box -->
        <div class="payment-info">
            <h4 style="color: #007bff; margin-bottom: 10px;">💡 Payment Information</h4>
            <p><strong>Receipt Date:</strong> <?php echo date('d/m/Y H:i:s'); ?></p>
            <p><strong>Status:</strong> <span style="color: #28a745; font-weight: bold;">COMPLETED</span></p>
            <?php if ($transaction['payment_method'] === 'bank_transfer' || $transaction['payment_method'] === 'mobile_money'): ?>
                <p><strong>Note:</strong> Payment verified and processed successfully.</p>
            <?php endif; ?>
            <p><strong>Valid Until:</strong> This receipt is valid for official purposes.</p>
        </div>

        <!-- Footer -->
        <div class="footer">
            <div class="footer-text">
                <p><strong>Thank you for your payment!</strong></p>
                <p>This is a computer-generated receipt and does not require a signature.</p>
                <p>For any queries regarding this receipt, please contact us at info@ksochandigarh.com</p>
                <p style="margin-top: 15px; font-size: 10px; color: #999;">
                    Generated on <?php echo date('d/m/Y H:i:s'); ?> | 
                    Receipt ID: <?php echo $transaction['receipt_number']; ?> | 
                    KSO Chandigarh Management System
                </p>
            </div>

            <!-- Signature Section -->
            <div class="signature-section no-print">
                <div class="signature-box">
                    <div class="signature-line">Authorized Signatory</div>
                </div>
                <div class="signature-box">
                    <div class="signature-line">Date: <?php echo date('d/m/Y'); ?></div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Auto-print functionality (optional)
        window.onload = function() {
            // Uncomment the line below to auto-print
            // window.print();
        };
    </script>
</body>
</html>

<?php
/**
 * Helper function to convert numbers to words (simplified version)
 */
function numberToWords($number) {
    $number = floor($number);
    if ($number == 0) return 'zero';
    
    $ones = array(
        '', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine',
        'ten', 'eleven', 'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen',
        'seventeen', 'eighteen', 'nineteen'
    );
    
    $tens = array(
        '', '', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'
    );
    
    if ($number < 20) {
        return $ones[$number];
    } elseif ($number < 100) {
        return $tens[floor($number / 10)] . ' ' . $ones[$number % 10];
    } elseif ($number < 1000) {
        return $ones[floor($number / 100)] . ' hundred ' . numberToWords($number % 100);
    } elseif ($number < 100000) {
        return numberToWords(floor($number / 1000)) . ' thousand ' . numberToWords($number % 1000);
    }
    
    return 'amount too large';
}
?>
