<?php
/**
 * Password Hash Checker - For development only
 */

$stored_hash = 'f925916e2754e5e03f75dd58a5733251';

// Common passwords to test
$common_passwords = [
    'password',
    'admin',
    'admin123',
    '123456',
    'kso123',
    'chandigarh',
    'chandigarh123',
    'kso',
    'ksochandigarh',
    'haominthang',
    'password123',
    '12345',
    'qwerty',
    'test',
    'test123',
    'demo',
    'demo123',
    'secret',
    'kso2024',
    'kso2025',
    // Adding more specific passwords based on the database usernames
    'hao',
    'lam',
    'len',
    'alex',
    'neihoi',
    'gouhen',
    'neng',
    'them',
    'lun',
    'haominthang123',
    'hao123',
    'default',
    'user',
    'user123',
    'temp',
    'temp123',
    'welcome',
    'welcome123',
    '1234',
    '12345678',
    'abcd1234',
    'changeme',
    'letmein',
    'system',
    'system123'
];

echo "Testing password hash: " . $stored_hash . "\n\n";

foreach ($common_passwords as $password) {
    $hash = md5($password);
    echo "Password: '{$password}' -> MD5: {$hash}";
    
    if ($hash === $stored_hash) {
        echo " ✅ MATCH FOUND!";
    }
    echo "\n";
}

// Also test with password_hash (modern PHP hashing)
echo "\n=== Testing if it's a password_hash format ===\n";
if (strpos($stored_hash, '$') === 0) {
    echo "This appears to be a password_hash format\n";
    
    foreach ($common_passwords as $password) {
        if (password_verify($password, $stored_hash)) {
            echo "Password: '{$password}' verified with password_verify() ✅\n";
        }
    }
} else {
    echo "This is NOT a password_hash format (no $ prefix)\n";
    echo "This appears to be MD5 or other legacy hash\n";
}

// Show how to create new password hashes
echo "\n=== How to create new password hashes ===\n";
echo "MD5 of 'password': " . md5('password') . "\n";
echo "password_hash of 'password': " . password_hash('password', PASSWORD_DEFAULT) . "\n";
echo "password_hash of 'admin123': " . password_hash('admin123', PASSWORD_DEFAULT) . "\n";
?>
