-- Additional Settings for KSO Chandigarh Settings Page
-- This file adds missing settings that are referenced in the settings HTML page

-- Insert additional system settings
INSERT INTO `settings` (`setting_key`, `setting_value`, `setting_type`, `description`, `is_public`, `created_at`, `updated_at`) VALUES
-- General Settings
('timezone', 'Asia/Kolkata', 'string', 'System Timezone', 0, NOW(), NOW()),
('date_format', 'd/m/Y', 'string', 'Date Display Format', 0, NOW(), NOW()),
('currency', 'INR', 'string', 'System Currency', 0, NOW(), NOW()),
('language', 'en', 'string', 'System Language', 0, NOW(), NOW()),
('maintenance_mode', '0', 'boolean', 'Maintenance Mode Status', 0, NOW(), NOW()),
('system_version', '1.0.0', 'string', 'System Version', 1, NOW(), NOW()),

-- Organization Extended Settings
('organization_short_name', 'KSO', 'string', 'Organization Short Name', 1, NOW(), NOW()),
('organization_description', 'Kashmiri Samaj Organization Chandigarh - Preserving Kashmiri culture and tradition', 'string', 'Organization Description', 1, NOW(), NOW()),
('organization_website', 'https://ksochandigarh.org', 'string', 'Organization Website', 1, NOW(), NOW()),
('organization_established', '1980', 'string', 'Organization Established Year', 1, NOW(), NOW()),

-- Membership Settings
('max_pending_members', '20', 'integer', 'Maximum pending members per admin', 0, NOW(), NOW()),

-- Fee Settings
('fee_reminder_days', '30', 'integer', 'Days before due date to send fee reminders', 0, NOW(), NOW()),
('late_fee_grace_days', '7', 'integer', 'Grace period days before applying late fees', 0, NOW(), NOW()),
('auto_fee_reminders', '1', 'boolean', 'Enable automatic fee reminders', 0, NOW(), NOW()),
('auto_late_fees', '1', 'boolean', 'Automatically apply late fees', 0, NOW(), NOW()),

-- Payment Settings
('payment_cash', '1', 'boolean', 'Accept cash payments', 0, NOW(), NOW()),
('payment_upi', '1', 'boolean', 'Accept UPI payments', 0, NOW(), NOW()),
('payment_bank', '1', 'boolean', 'Accept bank transfer payments', 0, NOW(), NOW()),
('upi_id', 'ksochandigarh@upi', 'string', 'Organization UPI ID', 0, NOW(), NOW()),
('bank_account', 'XXXX-XXXX-XXXX', 'string', 'Organization Bank Account', 0, NOW(), NOW()),

-- Email Automation Settings (extended)
('email_auto_welcome', '1', 'boolean', 'Send welcome emails to new members', 0, NOW(), NOW()),
('email_auto_approval', '1', 'boolean', 'Send approval notifications', 0, NOW(), NOW()),
('email_auto_events', '1', 'boolean', 'Send event reminders', 0, NOW(), NOW()),
('email_auto_fees', '1', 'boolean', 'Send fee payment reminders', 0, NOW(), NOW()),

-- Notification Settings (extended)
('email_notify_member_approval', '1', 'boolean', 'Email notifications for member approvals', 0, NOW(), NOW()),
('email_notify_event_reminders', '1', 'boolean', 'Email notifications for event reminders', 0, NOW(), NOW()),
('email_notify_fee_reminders', '1', 'boolean', 'Email notifications for fee reminders', 0, NOW(), NOW()),
('email_notify_welcome', '1', 'boolean', 'Email welcome notifications', 0, NOW(), NOW()),
('email_notify_documents', '1', 'boolean', 'Email notifications for document uploads', 0, NOW(), NOW()),
('email_notify_system', '1', 'boolean', 'Email notifications for system status', 0, NOW(), NOW()),

-- Real-time Notification Settings
('realtime_new_members', '1', 'boolean', 'Real-time notifications for new members', 0, NOW(), NOW()),
('realtime_payments', '1', 'boolean', 'Real-time notifications for payments', 0, NOW(), NOW()),
('realtime_event_registrations', '1', 'boolean', 'Real-time notifications for event registrations', 0, NOW(), NOW()),
('realtime_system_alerts', '1', 'boolean', 'Real-time system alerts', 0, NOW(), NOW()),

-- Security Settings
('min_password_length', '8', 'integer', 'Minimum password length', 0, NOW(), NOW()),
('password_expire_days', '90', 'integer', 'Password expiry in days (0 = never)', 0, NOW(), NOW()),
('require_uppercase', '1', 'boolean', 'Require uppercase letters in passwords', 0, NOW(), NOW()),
('require_lowercase', '1', 'boolean', 'Require lowercase letters in passwords', 0, NOW(), NOW()),
('require_numbers', '1', 'boolean', 'Require numbers in passwords', 0, NOW(), NOW()),
('require_special_chars', '0', 'boolean', 'Require special characters in passwords', 0, NOW(), NOW()),
('session_timeout', '60', 'integer', 'Session timeout in minutes', 0, NOW(), NOW()),
('max_login_attempts', '5', 'integer', 'Maximum login attempts before lockout', 0, NOW(), NOW()),
('lockout_duration', '15', 'integer', 'Account lockout duration in minutes', 0, NOW(), NOW()),
('enable_two_factor', '0', 'boolean', 'Enable two-factor authentication', 0, NOW(), NOW()),
('log_login_attempts', '1', 'boolean', 'Log all login attempts', 0, NOW(), NOW()),
('alert_suspicious_activity', '1', 'boolean', 'Alert on suspicious activity', 0, NOW(), NOW()),
('allowed_ips', '', 'string', 'Allowed IP addresses (comma-separated)', 0, NOW(), NOW())

ON DUPLICATE KEY UPDATE 
    `setting_value` = VALUES(`setting_value`),
    `updated_at` = NOW();

-- Create additional tables for enhanced settings functionality

-- Email Templates Table
CREATE TABLE IF NOT EXISTS `email_templates` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `name` varchar(100) NOT NULL,
    `subject` varchar(255) NOT NULL,
    `body` text NOT NULL,
    `purpose` varchar(255) DEFAULT NULL,
    `status` enum('active','inactive') DEFAULT 'active',
    `variables` json DEFAULT NULL,
    `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
    `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `unique_template_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default email templates
INSERT INTO `email_templates` (`name`, `subject`, `body`, `purpose`, `status`, `variables`) VALUES
('welcome_member', 'Welcome to KSO Chandigarh', 'Dear {{member_name}},\n\nWelcome to Kashmiri Samaj Organization Chandigarh! We are delighted to have you as a member of our community.\n\nYour membership details:\nMember ID: {{member_id}}\nMembership Type: {{membership_type}}\n\nBest regards,\nKSO Chandigarh Team', 'Welcome email for new members', 'active', '["member_name", "member_id", "membership_type"]'),
('member_approval', 'Membership Approved', 'Dear {{member_name}},\n\nCongratulations! Your membership application has been approved.\n\nYou can now access all member benefits and participate in our events.\n\nBest regards,\nKSO Chandigarh Team', 'Member approval notification', 'active', '["member_name"]'),
('fee_reminder', 'Fee Payment Reminder', 'Dear {{member_name}},\n\nThis is a reminder that your membership fee of ₹{{fee_amount}} is due on {{due_date}}.\n\nPlease make the payment at your earliest convenience.\n\nBest regards,\nKSO Chandigarh Team', 'Fee payment reminder', 'active', '["member_name", "fee_amount", "due_date"]'),
('event_reminder', 'Event Reminder', 'Dear {{member_name}},\n\nThis is a reminder about the upcoming event: {{event_name}}\n\nDate: {{event_date}}\nTime: {{event_time}}\nVenue: {{event_venue}}\n\nWe look forward to seeing you there!\n\nBest regards,\nKSO Chandigarh Team', 'Event reminder notification', 'active', '["member_name", "event_name", "event_date", "event_time", "event_venue"]')
ON DUPLICATE KEY UPDATE 
    `subject` = VALUES(`subject`),
    `body` = VALUES(`body`),
    `updated_at` = NOW();

-- System Logs Table
CREATE TABLE IF NOT EXISTS `system_logs` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `level` enum('error','warning','info','debug') NOT NULL,
    `message` text NOT NULL,
    `context` json DEFAULT NULL,
    `user_id` int(11) DEFAULT NULL,
    `ip_address` varchar(45) DEFAULT NULL,
    `user_agent` text DEFAULT NULL,
    `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_level` (`level`),
    KEY `idx_created_at` (`created_at`),
    KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Security Logs Table
CREATE TABLE IF NOT EXISTS `security_logs` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `event_type` enum('login_success','login_failed','logout','password_change','account_locked','suspicious_activity') NOT NULL,
    `user_id` int(11) DEFAULT NULL,
    `username` varchar(100) DEFAULT NULL,
    `ip_address` varchar(45) NOT NULL,
    `user_agent` text DEFAULT NULL,
    `details` json DEFAULT NULL,
    `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `idx_event_type` (`event_type`),
    KEY `idx_user_id` (`user_id`),
    KEY `idx_ip_address` (`ip_address`),
    KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Backup History Table
CREATE TABLE IF NOT EXISTS `backup_history` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `filename` varchar(255) NOT NULL,
    `type` enum('full','database','files') NOT NULL,
    `size` bigint(20) DEFAULT NULL,
    `status` enum('pending','completed','failed') DEFAULT 'pending',
    `created_by` int(11) DEFAULT NULL,
    `file_path` varchar(500) DEFAULT NULL,
    `notes` text DEFAULT NULL,
    `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
    `completed_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `idx_type` (`type`),
    KEY `idx_status` (`status`),
    KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Email Statistics Table
CREATE TABLE IF NOT EXISTS `email_statistics` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `template_id` int(11) DEFAULT NULL,
    `recipient_email` varchar(255) NOT NULL,
    `subject` varchar(255) NOT NULL,
    `status` enum('sent','failed','bounced','delivered','opened') DEFAULT 'sent',
    `error_message` text DEFAULT NULL,
    `sent_at` datetime DEFAULT CURRENT_TIMESTAMP,
    `delivered_at` datetime DEFAULT NULL,
    `opened_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `idx_template_id` (`template_id`),
    KEY `idx_status` (`status`),
    KEY `idx_sent_at` (`sent_at`),
    FOREIGN KEY (`template_id`) REFERENCES `email_templates` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert some sample system logs
INSERT INTO `system_logs` (`level`, `message`, `context`, `user_id`, `ip_address`) VALUES
('info', 'System started successfully', '{"version": "1.0.0", "startup_time": "2025-07-13 10:00:00"}', NULL, '127.0.0.1'),
('info', 'Database connection established', '{"database": "ktxmmosu_kso_chandigarh"}', NULL, '127.0.0.1'),
('info', 'Settings system initialized', '{"total_settings": 45}', NULL, '127.0.0.1');

-- Insert sample backup history
INSERT INTO `backup_history` (`filename`, `type`, `size`, `status`, `created_by`, `file_path`, `completed_at`) VALUES
('backup_2025-07-13_full.zip', 'full', 52428800, 'completed', 1, '/backups/backup_2025-07-13_full.zip', '2025-07-13 02:00:00'),
('backup_2025-07-12_db.sql', 'database', 2097152, 'completed', 1, '/backups/backup_2025-07-12_db.sql', '2025-07-12 02:00:00'),
('backup_2025-07-11_full.zip', 'full', 48234496, 'completed', 1, '/backups/backup_2025-07-11_full.zip', '2025-07-11 02:00:00');

-- Add foreign key constraints if admin_users table exists
-- ALTER TABLE `security_logs` ADD FOREIGN KEY (`user_id`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL;
-- ALTER TABLE `backup_history` ADD FOREIGN KEY (`created_by`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL;

SELECT 'Additional settings and tables created successfully!' as Status;
