// Handles member login form
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('loginForm');
    const msg = document.getElementById('loginMsg');
    form.addEventListener('submit', async function(e) {
        e.preventDefault();
        msg.textContent = 'Logging in...';
        const data = Object.fromEntries(new FormData(form));
        try {
            const res = await fetch('../../api/members/login', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            });
            const result = await res.json();
            if (result.success) {
                msg.textContent = 'Login successful! Redirecting...';
                setTimeout(() => {
                    window.location.href = '../member/dashboard';
                }, 1000);
            } else {
                msg.textContent = result.error || 'Login failed.';
            }
        } catch (err) {
            msg.textContent = 'Login failed. Please try again.';
        }
    });
});
