// KSO Chandigarh Management System - URL Handler
class UrlHandler {
    static init() {
        // Convert all navigation links to clean URLs
        document.addEventListener('DOMContentLoaded', () => {
            document.querySelectorAll('a[href$=".html"]').forEach(link => {
                link.href = link.href.replace('.html', '');
            });

            // Handle form submissions
            document.querySelectorAll('form').forEach(form => {
                form.addEventListener('submit', (e) => {
                    const action = form.action;
                    if (action && action.endsWith('.html')) {
                        form.action = action.replace('.html', '');
                    }
                });
            });

            // Initialize sidebar navigation and treeview
            this.initSidebarNavigation();
        });
    }

    static initSidebarNavigation() {
        // Handle treeview toggles
        document.querySelectorAll('.sidebar-menu .nav-link').forEach(link => {
            const arrow = link.querySelector('.nav-arrow');
            if (arrow) {
                link.addEventListener('click', (e) => {
                    e.preventDefault();
                    const parentItem = link.closest('.nav-item');
                    const treeview = parentItem.querySelector('.nav-treeview');
                    
                    if (treeview) {
                        const isOpen = parentItem.classList.contains('menu-open');
                        
                        // Close all other open menus
                        document.querySelectorAll('.nav-item.menu-open').forEach(item => {
                            if (item !== parentItem) {
                                item.classList.remove('menu-open');
                            }
                        });
                        
                        // Toggle current menu
                        parentItem.classList.toggle('menu-open', !isOpen);
                    }
                });
            }
        });

        // Set active menu based on current page
        this.setActiveNavigation();
    }

    static setActiveNavigation() {
        const currentPath = window.location.pathname;
        const currentPage = currentPath.split('/').pop() || 'dashboard';
        
        // Remove all active classes
        document.querySelectorAll('.nav-link').forEach(link => {
            link.classList.remove('active');
        });
        
        // Set active class for current page
        document.querySelectorAll('.nav-link').forEach(link => {
            const href = link.getAttribute('href');
            if (href && (href.includes(currentPage) || 
                (currentPage === 'dashboard' && href.includes('dashboard')))) {
                link.classList.add('active');
                
                // If it's a sub-menu item, open parent menu
                const parentTreeview = link.closest('.nav-treeview');
                if (parentTreeview) {
                    const parentItem = parentTreeview.closest('.nav-item');
                    parentItem.classList.add('menu-open');
                    
                    // Also mark parent link as active
                    const parentLink = parentItem.querySelector('.nav-link');
                    if (parentLink) {
                        parentLink.classList.add('active');
                    }
                }
            }
        });
    }

    static navigate(path) {
        // Remove .html extension if present
        path = path.replace('.html', '');
        window.location.href = path;
    }

    static getCleanPath(path) {
        return path.replace('.html', '');
    }

    static updateHistory(title, path) {
        // Update browser history with clean URL
        const cleanPath = this.getCleanPath(path);
        window.history.pushState({}, title, cleanPath);
    }
}

// Initialize URL handler
UrlHandler.init();
