<?php
/**
 * KSO Chandigarh Hosting-Style Authentication Handler
 * Based on how the hosting site handles password verification
 */

// Database configuration (update with your hosting details)
$hosting_config = [
    'host' => 'localhost',
    'database' => 'ktxmmosu_kso_chandigarh',
    'username' => 'root', // Update for hosting
    'password' => '',     // Update for hosting
];

// Target hash from hosting database
$target_hash = 'f925916e2754e5e03f75dd58a5733251';

function connectToDatabase($config) {
    try {
        $pdo = new PDO(
            "mysql:host={$config['host']};dbname={$config['database']};charset=utf8mb4",
            $config['username'],
            $config['password'],
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
            ]
        );
        return $pdo;
    } catch (PDOException $e) {
        return null;
    }
}

function hostingStylePasswordUpdate($new_password = 'admin123') {
    global $hosting_config;
    
    echo "=== KSO Chandigarh Hosting-Style Password Update ===\n";
    
    $pdo = connectToDatabase($hosting_config);
    if (!$pdo) {
        echo "❌ Database connection failed. Using development mode.\n";
        return false;
    }
    
    // Generate secure password hash (hosting-style)
    $secure_hash = password_hash($new_password, PASSWORD_DEFAULT, ['cost' => 12]);
    
    echo "🔐 Updating passwords using hosting method...\n";
    echo "New password: '{$new_password}'\n";
    echo "Secure hash: {$secure_hash}\n\n";
    
    try {
        // Update all admin users with new secure hash
        $stmt = $pdo->prepare("UPDATE admins SET password_hash = ?");
        $result = $stmt->execute([$secure_hash]);
        
        if ($result) {
            $count = $stmt->rowCount();
            echo "✅ Successfully updated {$count} admin accounts\n";
            
            // Verify the update
            $verify_stmt = $pdo->prepare("SELECT username, password_hash FROM admins LIMIT 3");
            $verify_stmt->execute();
            $users = $verify_stmt->fetchAll();
            
            echo "\n📋 Updated user verification:\n";
            foreach ($users as $user) {
                echo "- {$user['username']}: " . substr($user['password_hash'], 0, 30) . "...\n";
            }
            
            echo "\n🎯 Authentication Options:\n";
            echo "Username: admin\n";
            echo "Password: {$new_password}\n";
            echo "OR\n";
            echo "Username: haominthang\n";
            echo "Password: {$new_password}\n";
            
            return true;
        } else {
            echo "❌ Failed to update passwords\n";
            return false;
        }
        
    } catch (PDOException $e) {
        echo "❌ Database error: " . $e->getMessage() . "\n";
        return false;
    }
}

function testHostingAuthentication($username, $password) {
    global $hosting_config;
    
    $pdo = connectToDatabase($hosting_config);
    if (!$pdo) {
        echo "❌ Database connection failed\n";
        return false;
    }
    
    try {
        $stmt = $pdo->prepare("SELECT password_hash FROM admins WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch();
        
        if ($user && password_verify($password, $user['password_hash'])) {
            echo "✅ Authentication successful for {$username}\n";
            return true;
        } else {
            echo "❌ Authentication failed for {$username}\n";
            return false;
        }
        
    } catch (PDOException $e) {
        echo "❌ Authentication error: " . $e->getMessage() . "\n";
        return false;
    }
}

function generateHostingCompatibleHashes() {
    echo "=== Hosting-Compatible Password Hashes ===\n";
    
    $passwords = ['admin123', 'password', 'kso123', 'chandigarh123'];
    
    foreach ($passwords as $password) {
        $hash = password_hash($password, PASSWORD_DEFAULT, ['cost' => 12]);
        echo "Password: '{$password}'\n";
        echo "Hash: {$hash}\n";
        echo "SQL: UPDATE admins SET password_hash = '{$hash}' WHERE username = 'haominthang';\n\n";
    }
}

// Main execution based on hosting site approach
if (isset($_GET['action'])) {
    switch ($_GET['action']) {
        case 'update':
            $password = $_GET['password'] ?? 'admin123';
            hostingStylePasswordUpdate($password);
            break;
            
        case 'test':
            $username = $_GET['username'] ?? 'admin';
            $password = $_GET['password'] ?? 'admin123';
            testHostingAuthentication($username, $password);
            break;
            
        case 'generate':
            generateHostingCompatibleHashes();
            break;
            
        default:
            echo "Available actions: update, test, generate\n";
            break;
    }
} else {
    // Default action - update passwords using hosting method
    echo "🌐 Using hosting site authentication method...\n\n";
    
    // Try to update with hosting-style secure passwords
    if (hostingStylePasswordUpdate('admin123')) {
        echo "\n✅ Password update complete!\n";
        echo "\n🔐 Test authentication:\n";
        testHostingAuthentication('admin', 'admin123');
        testHostingAuthentication('haominthang', 'admin123');
    } else {
        echo "\n⚠️  Database update failed. Use development mode:\n";
        echo "Username: admin, Password: admin123\n";
        echo "Username: haominthang, Password: password\n";
    }
    
    echo "\n📝 For manual database update, use these secure hashes:\n";
    generateHostingCompatibleHashes();
}
?>
