// Handles member registration form

document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('registerForm');
    const msg = document.getElementById('registerMsg');
    const membershipType = form.elements['membership_type'];
    const dependentsSection = document.getElementById('dependentsSection');
    const dependentsList = document.getElementById('dependentsList');
    const addDependentBtn = document.getElementById('addDependent');
    let dependents = [];

    membershipType.addEventListener('change', function() {
        if (this.value === 'family') {
            dependentsSection.style.display = '';
        } else {
            dependentsSection.style.display = 'none';
            dependents = [];
            dependentsList.innerHTML = '';
        }
    });

    addDependentBtn.addEventListener('click', function() {
        const idx = dependents.length;
        const depDiv = document.createElement('div');
        depDiv.innerHTML = `
            <label>First Name: <input type="text" name="dep_first_name_${idx}" required></label>
            <label>Last Name: <input type="text" name="dep_last_name_${idx}" required></label>
            <label>Relationship: <input type="text" name="dep_relationship_${idx}" required></label>
            <button type="button" class="removeDependent">Remove</button>
            <br>
        `;
        dependentsList.appendChild(depDiv);
        dependents.push(depDiv);
        depDiv.querySelector('.removeDependent').onclick = function() {
            dependentsList.removeChild(depDiv);
            dependents = dependents.filter(d => d !== depDiv);
        };
    });

    form.addEventListener('submit', async function(e) {
        e.preventDefault();
        msg.textContent = 'Registering...';
        const data = Object.fromEntries(new FormData(form));
        // Collect dependents
        if (membershipType.value === 'family') {
            data.dependents = dependents.map((depDiv, i) => {
                return {
                    first_name: depDiv.querySelector(`[name^='dep_first_name_']`).value,
                    last_name: depDiv.querySelector(`[name^='dep_last_name_']`).value,
                    relationship: depDiv.querySelector(`[name^='dep_relationship_']`).value
                };
            });
        }
        try {
            const res = await fetch('../api/auth/register', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            });
            const result = await res.json();
            if (result.success) {
                msg.textContent = 'Registration successful! Please check your email.';
                form.reset();
                dependentsList.innerHTML = '';
            } else {
                msg.textContent = result.error || 'Registration failed.';
            }
        } catch (err) {
            msg.textContent = 'Registration failed. Please try again.';
        }
    });
});
