// inject-url-handler.js
const fs = require('fs');
const path = require('path');

// Frontend pages directory
const pagesDir = './frontend/pages';

// Read all HTML files in the pages directory
fs.readdir(pagesDir, (err, files) => {
    if (err) {
        console.error('Error reading directory:', err);
        return;
    }

    files.filter(file => file.endsWith('.html')).forEach(file => {
        const filePath = path.join(pagesDir, file);
        
        // Read file content
        fs.readFile(filePath, 'utf8', (err, content) => {
            if (err) {
                console.error(`Error reading file ${file}:`, err);
                return;
            }

            // Check if URL handler is already included
            if (content.includes('url-handler.js')) {
                return;
            }

            // Add URL handler script before closing body tag
            const updatedContent = content.replace(
                '</body>',
                '    <!-- URL Handler -->\n    <script src="../js/url-handler.js"></script>\n</body>'
            );

            // Write updated content back to file
            fs.writeFile(filePath, updatedContent, 'utf8', err => {
                if (err) {
                    console.error(`Error writing file ${file}:`, err);
                    return;
                }
                console.log(`Updated ${file}`);
            });
        });
    });
});
