<?php
/**
 * KSO Chandigarh Management System - Database Configuration
 * For PDF Generation and Admin API
 */

// Security check
if (!defined('API_ACCESS')) {
    session_start();
    if (!isset($_SESSION['admin_id'])) {
        http_response_code(401);
        die('Unauthorized access');
    }
}

// Production flag - set to true when deployed
$is_production = false;

// Database Configuration
$db_config = [
    'host' => 'localhost',
    'dbname' => $is_production ? 'ktxmmosu_kso_chandigarh' : 'ktxmmosu_kso_chandigarh',
    'username' => $is_production ? 'ktxmmosu_kso_db' : 'root',
    'password' => $is_production ? 'KSO@2025' : '',
    'charset' => 'utf8mb4',
    'options' => [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8mb4'
    ]
];

// Create DSN
$dsn = "mysql:host={$db_config['host']};dbname={$db_config['dbname']};charset={$db_config['charset']}";
$username = $db_config['username'];
$password = $db_config['password'];

// Test database connection
try {
    $test_conn = new PDO($dsn, $username, $password, $db_config['options']);
    // Connection successful
} catch (PDOException $e) {
    error_log('Database connection error: ' . $e->getMessage());
    if (!$is_production) {
        throw new Exception('Database connection failed: ' . $e->getMessage());
    } else {
        throw new Exception('Database connection failed. Please check configuration.');
    }
}

// Email Configuration
$email_config = [
    'smtp_host' => 'mail.kso-chd.online',
    'smtp_port' => 465, // SSL port
    'smtp_port_tls' => 587, // TLS port (alternative)
    'smtp_username' => 'no-reply@kso-chd.online',
    'smtp_password' => 'KSO@2025', // Email account password
    'from_email' => 'no-reply@kso-chd.online',
    'from_name' => 'KSO Chandigarh',
    'reply_to' => 'info@kso-chd.online',
    'encryption' => 'ssl', // or 'tls'
    'auth_required' => true,
    'incoming_server' => 'mail.kso-chd.online',
    'incoming_port_imap' => 993,
    'incoming_port_pop3' => 995
];

// File Upload Configuration
$upload_config = [
    'max_file_size' => 10 * 1024 * 1024, // 10MB
    'allowed_types' => ['pdf', 'doc', 'docx', 'jpg', 'jpeg', 'png', 'gif'],
    'upload_path' => dirname(__DIR__) . '/uploads/',
    'temp_path' => sys_get_temp_dir() . '/'
];

// PDF Configuration
$pdf_config = [
    'tcpdf_path' => dirname(__DIR__) . '/TCPDF-main/',
    'company_name' => 'KSO Organization',
    'company_address' => 'KSO Headquarters, Chandigarh',
    'company_phone' => '(0172) 123-4567',
    'company_email' => 'info@kso.com',
    'logo_path' => dirname(__DIR__) . '/assets/logo.png',
    'signature_path' => dirname(__DIR__) . '/assets/signature.png'
];

// Ensure required directories exist
$required_dirs = [
    $upload_config['upload_path'],
    dirname(__DIR__) . '/logs/',
    dirname(__DIR__) . '/temp/'
];

foreach ($required_dirs as $dir) {
    if (!file_exists($dir)) {
        mkdir($dir, 0755, true);
    }
}

// Error reporting
if (!$is_production) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(E_ERROR | E_WARNING | E_PARSE);
    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    ini_set('error_log', dirname(__DIR__) . '/logs/error.log');
}

// Security settings
if (session_status() == PHP_SESSION_NONE) {
    ini_set('session.cookie_httponly', 1);
    ini_set('session.cookie_secure', $is_production ? 1 : 0);
    ini_set('session.use_strict_mode', 1);
}

// Timezone
date_default_timezone_set('Asia/Kolkata');
?>
