<?php
header('Content-Type: application/json');

try {
    // Direct database connection
    $host = 'localhost';
    $dbname = 'ktxmmosu_kso_chandigarh';
    $username = 'ktxmmosu_kso_db';
    $password = 'KSO@2025';
    
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $filter = $_GET['filter'] ?? 'upcoming';

    // Check if events table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'events'");
    if ($stmt->rowCount() == 0) {
        // Create events table
        $pdo->exec("CREATE TABLE events (
            id INT AUTO_INCREMENT PRIMARY KEY,
            title VARCHAR(255),
            event_date DATE,
            location VARCHAR(255),
            status VARCHAR(50) DEFAULT 'upcoming',
            attendees INT DEFAULT 0,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )");
        
        // Insert sample events
        $stmt = $pdo->prepare("INSERT INTO events (title, event_date, location, status, attendees) VALUES (?, ?, ?, ?, ?)");
        $sampleEvents = [
            ['Annual General Meeting', '2025-08-15', 'Community Hall', 'upcoming', 25],
            ['Cultural Event', '2025-08-28', 'KSO Center', 'upcoming', 40],
            ['Sports Tournament', '2025-09-10', 'Sports Complex', 'upcoming', 60],
            ['Past Event 1', '2025-06-15', 'Community Hall', 'completed', 50],
            ['Current Event', '2025-07-13', 'Sports Complex', 'active', 80]
        ];
        foreach ($sampleEvents as $event) {
            $stmt->execute($event);
        }
    }

    // Build query based on filter
    $whereClause = '';
    switch ($filter) {
        case 'upcoming':
            $whereClause = "WHERE event_date > CURDATE()";
            break;
        case 'current':
            $whereClause = "WHERE event_date = CURDATE()";
            break;
        case 'past':
            $whereClause = "WHERE event_date < CURDATE()";
            break;
        default:
            $whereClause = "";
            break;
    }

    $stmt = $pdo->query("SELECT * FROM events $whereClause ORDER BY event_date DESC LIMIT 50");
    $events = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'data' => $events,
        'count' => count($events),
        'filter' => $filter
    ]);

} catch (Exception $e) {
    // Return sample data if database fails
    echo json_encode([
        'success' => true,
        'data' => [
            ['id' => 1, 'title' => 'Annual General Meeting', 'event_date' => '2025-08-15', 'location' => 'Community Hall', 'status' => 'upcoming', 'attendees' => 25],
            ['id' => 2, 'title' => 'Cultural Event', 'event_date' => '2025-08-28', 'location' => 'KSO Center', 'status' => 'upcoming', 'attendees' => 40],
            ['id' => 3, 'title' => 'Sports Tournament', 'event_date' => '2025-09-10', 'location' => 'Sports Complex', 'status' => 'upcoming', 'attendees' => 60]
        ],
        'count' => 3,
        'filter' => $filter,
        'note' => 'Sample data - database connection failed'
    ]);
}
?>
