<?php
header('Content-Type: application/json');

try {
    // Direct database connection
    $host = 'localhost';
    $dbname = 'ktxmmosu_kso_chandigarh';
    $username = 'ktxmmosu_kso_db';
    $password = 'KSO@2025';
    
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Check if members table exists, if not create it
    $stmt = $pdo->query("SHOW TABLES LIKE 'members'");
    if ($stmt->rowCount() == 0) {
        // Create basic members table
        $pdo->exec("CREATE TABLE members (
            id INT AUTO_INCREMENT PRIMARY KEY,
            kso_id VARCHAR(20),
            name VARCHAR(255),
            status VARCHAR(50) DEFAULT 'pending',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )");
        
        // Insert sample data
        $stmt = $pdo->prepare("INSERT INTO members (kso_id, name, status) VALUES (?, ?, ?)");
        $sampleData = [
            ['KSO001', 'John Doe', 'approved'],
            ['KSO002', 'Jane Smith', 'approved'],
            ['KSO003', 'Raj Kumar', 'pending'],
            ['KSO004', 'Priya Sharma', 'approved'],
            ['KSO005', 'Amit Singh', 'pending']
        ];
        foreach ($sampleData as $member) {
            $stmt->execute($member);
        }
    }

    // Try to fetch from existing table structure
    try {
        $stmt = $pdo->query("SELECT * FROM members LIMIT 1");
        $sampleRow = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Build query based on available columns
        $columns = array_keys($sampleRow ?: []);
        $selectCols = implode(', ', $columns);
        
        if (empty($selectCols)) {
            $selectCols = 'id, name, status, created_at';
        }
        
        $stmt = $pdo->query("SELECT $selectCols FROM members ORDER BY created_at DESC LIMIT 10");
        $members = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
    } catch (Exception $e) {
        // Fallback query if table structure is different
        $stmt = $pdo->query("SELECT id, name, status, created_at FROM members ORDER BY created_at DESC LIMIT 10");
        $members = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Format data consistently
    $formattedMembers = [];
    foreach ($members as $member) {
        $formattedMembers[] = [
            'id' => $member['id'] ?? '',
            'kso_id' => $member['kso_id'] ?? $member['id'] ?? '',
            'full_name' => $member['name'] ?? $member['full_name'] ?? 'Unknown',
            'status' => $member['status'] ?? 'pending',
            'created_at' => $member['created_at'] ?? date('Y-m-d H:i:s')
        ];
    }

    echo json_encode([
        'success' => true,
        'data' => $formattedMembers,
        'count' => count($formattedMembers)
    ]);

} catch (Exception $e) {
    // Return sample data if database fails
    echo json_encode([
        'success' => true,
        'data' => [
            ['id' => 1, 'kso_id' => 'KSO001', 'full_name' => 'John Doe', 'status' => 'approved', 'created_at' => '2025-07-01'],
            ['id' => 2, 'kso_id' => 'KSO002', 'full_name' => 'Jane Smith', 'status' => 'approved', 'created_at' => '2025-07-02'],
            ['id' => 3, 'kso_id' => 'KSO003', 'full_name' => 'Raj Kumar', 'status' => 'pending', 'created_at' => '2025-07-03']
        ],
        'count' => 3,
        'note' => 'Sample data - database connection failed'
    ]);
}
?>
