<?php
header('Content-Type: application/json');

try {
    // Include database connection
    require_once '../config/database.php';
    
    // Get database connection
    $database = new Database();
    $pdo = $database->getConnection();

    $filter = $_GET['filter'] ?? '';

    // Check if transactions table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'transactions'");
    if ($stmt->rowCount() == 0) {
        // Return empty data, don't create dummy data
        echo json_encode([
            'success' => true,
            'data' => [],
            'count' => 0,
            'message' => 'Transactions table does not exist yet'
        ]);
        exit;
    }

    // Build query based on filter
    $whereClause = '';
    if ($filter && in_array($filter, ['income', 'expense'])) {
        $whereClause = "WHERE type = :filter";
    }

    $query = "SELECT * FROM transactions $whereClause ORDER BY created_at DESC LIMIT 50";
    $stmt = $pdo->prepare($query);
    if ($filter && in_array($filter, ['income', 'expense'])) {
        $stmt->bindParam(':filter', $filter);
    }
    $stmt->execute();
    $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'data' => $transactions,
        'count' => count($transactions),
        'filter' => $filter
    ]);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage(),
        'data' => []
    ]);
}
?>
?>
