<?php
header('Content-Type: application/json');

try {
    // Direct database connection
    $host = 'localhost';
    $dbname = 'ktxmmosu_kso_chandigarh';
    $username = 'ktxmmosu_kso_db';
    $password = 'KSO@2025';
    
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $filter = $_GET['filter'] ?? '';

    // Check if transactions table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'transactions'");
    if ($stmt->rowCount() == 0) {
        // Create transactions table
        $pdo->exec("CREATE TABLE transactions (
            id INT AUTO_INCREMENT PRIMARY KEY,
            member_name VARCHAR(255),
            type ENUM('income', 'expense'),
            category VARCHAR(100),
            amount DECIMAL(10,2),
            description TEXT,
            status VARCHAR(50) DEFAULT 'completed',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )");
        
        // Insert sample transactions
        $stmt = $pdo->prepare("INSERT INTO transactions (member_name, type, category, amount, description, status) VALUES (?, ?, ?, ?, ?, ?)");
        $sampleTransactions = [
            ['Membership Fee - John Doe', 'income', 'Membership', 500.00, 'Annual membership fee', 'completed'],
            ['Event Registration - Jane Smith', 'income', 'Events', 200.00, 'Cultural event registration', 'completed'],
            ['Office Supplies', 'expense', 'Administrative', 150.00, 'Stationery and office supplies', 'completed'],
            ['Venue Booking - Raj Kumar', 'income', 'Events', 300.00, 'Sports tournament registration', 'pending'],
            ['Utilities Bill', 'expense', 'Utilities', 250.00, 'Monthly electricity bill', 'completed']
        ];
        foreach ($sampleTransactions as $transaction) {
            $stmt->execute($transaction);
        }
    }

    // Build query based on filter
    $whereClause = '';
    if ($filter && in_array($filter, ['income', 'expense'])) {
        $whereClause = "WHERE type = :filter";
    }

    $query = "SELECT * FROM transactions $whereClause ORDER BY created_at DESC LIMIT 50";
    $stmt = $pdo->prepare($query);
    if ($filter && in_array($filter, ['income', 'expense'])) {
        $stmt->bindParam(':filter', $filter);
    }
    $stmt->execute();
    $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'data' => $transactions,
        'count' => count($transactions),
        'filter' => $filter
    ]);

} catch (Exception $e) {
    // Return sample data if database fails
    echo json_encode([
        'success' => true,
        'data' => [
            ['id' => 1, 'member_name' => 'Membership Fee - John Doe', 'type' => 'income', 'category' => 'Membership', 'amount' => 500.00, 'status' => 'completed'],
            ['id' => 2, 'member_name' => 'Event Registration - Jane Smith', 'type' => 'income', 'category' => 'Events', 'amount' => 200.00, 'status' => 'completed'],
            ['id' => 3, 'member_name' => 'Office Supplies', 'type' => 'expense', 'category' => 'Administrative', 'amount' => 150.00, 'status' => 'completed']
        ],
        'count' => 3,
        'filter' => $filter,
        'note' => 'Sample data - database connection failed'
    ]);
}
?>
