<?php
// Debug script to check file paths
echo "<h2>Current working directory:</h2>";
echo getcwd() . "<br><br>";

echo "<h2>Directory listing of current directory:</h2>";
$files = scandir('.');
foreach ($files as $file) {
    echo $file . "<br>";
}

echo "<h2>Directory listing of parent directory:</h2>";
if (is_dir('..')) {
    $files = scandir('..');
    foreach ($files as $file) {
        echo $file . "<br>";
    }
}

echo "<h2>Check if config/database.php exists:</h2>";
if (file_exists('../config/database.php')) {
    echo "✅ ../config/database.php exists<br>";
} else {
    echo "❌ ../config/database.php NOT found<br>";
}

echo "<h2>Check if config directory exists:</h2>";
if (is_dir('../config')) {
    echo "✅ ../config directory exists<br>";
    echo "Contents of ../config:<br>";
    $files = scandir('../config');
    foreach ($files as $file) {
        echo "  - " . $file . "<br>";
    }
} else {
    echo "❌ ../config directory NOT found<br>";
}

echo "<h2>Absolute path check:</h2>";
$abs_path = realpath('../config/database.php');
echo "Absolute path: " . ($abs_path ? $abs_path : 'NOT FOUND') . "<br>";
?>