# Assignment System User Guide

## Introduction

The KSO Chandigarh Admin Panel includes a comprehensive member assignment system that allows admins to assign members to themselves or other admins for various purposes including review, approval, verification, and follow-up.

This guide covers how to use the assignment system effectively.

## Table of Contents

1. [Viewing Assignments](#viewing-assignments)
2. [Creating New Assignments](#creating-new-assignments)
3. [Managing Assignments](#managing-assignments)
4. [Assignment Types](#assignment-types)
5. [Priority Levels](#priority-levels)
6. [Assignment Statistics](#assignment-statistics)
7. [Troubleshooting](#troubleshooting)

## Viewing Assignments

### View Members Assigned to You

1. Navigate to **Dashboard** > **My Assignments**
2. The default view shows all **Active** assignments
3. Use the status filter to view other assignment statuses:
   - **Active**: Current assignments
   - **Completed**: Finished assignments
   - **Cancelled**: Canceled assignments
   - **Overdue**: Past-due assignments
   - **All**: View all assignments regardless of status

![My Assignments Screen](../images/my-assignments.png)

### View Assignments for a Specific Member

1. Navigate to **Members** > **Member List**
2. Click on a member's name to view their profile
3. Scroll down to the **Assignments** section
4. Here you'll see all assignments for this member

![Member Assignments Screen](../images/member-assignments.png)

## Creating New Assignments

### Assign a Member

1. From a member's profile page, click the **Assign** button
2. Alternatively, from the **Members** list, use the dropdown menu and select **Assign**
3. In the assignment dialog:
   - Select the **Admin** to assign to
   - Choose an **Assignment Type** (review, approval, verification, follow-up)
   - Set a **Priority** level (low, normal, high, urgent)
   - Optionally add **Notes** about the assignment
   - Optionally set a **Due Date**
4. Click **Assign** to create the assignment

![Create Assignment Dialog](../images/create-assignment.png)

### Bulk Assignments

1. From the **Members** list, select multiple members using the checkboxes
2. Click the **Bulk Actions** dropdown
3. Select **Assign**
4. Complete the assignment form as above
5. All selected members will be assigned to the specified admin

## Managing Assignments

### Complete an Assignment

1. From your **My Assignments** list, find the assignment you want to complete
2. Click the **Complete** button
3. Add any completion notes in the dialog
4. Click **Complete** to mark the assignment as completed

### Cancel an Assignment

1. From either your assignments or a member's assignments, find the assignment
2. Click the **Cancel** button
3. Provide a reason for cancellation
4. Click **Cancel Assignment** to mark it as cancelled

### Transfer Assignments

Admins can transfer assignments to other admins:

1. Navigate to **Assignments** > **Transfer**
2. Select the **Source Admin** (from whom to transfer)
3. Select the **Destination Admin** (to whom to transfer)
4. Optionally filter by **Assignment Type** or **Priority**
5. Add optional notes about the transfer
6. Click **Transfer** to move the assignments

![Transfer Assignments Screen](../images/transfer-assignments.png)

## Assignment Types

The system supports four assignment types:

1. **Review**: Standard review of member information or status
   - Use for routine checks of member profiles
   - Default assignment type for most operations

2. **Approval**: Specifically for approval workflows
   - Use when a member needs formal approval for membership, event participation, etc.
   - Often has associated documents that need verification

3. **Verification**: Document or information verification
   - Use when specific documents or information needs to be verified
   - Examples: ID proof, educational certificates, address verification

4. **Follow-up**: Follow up with member on specific issues
   - Use when further communication with the member is needed
   - Examples: Incomplete information, clarification needed

## Priority Levels

Assignments can have four priority levels:

1. **Low** (Gray): Non-urgent matters
   - Routine reviews
   - Tasks that can be completed when time permits

2. **Normal** (Blue): Standard priority
   - Default for most assignments
   - Should be completed within standard timeframes

3. **High** (Yellow): Higher than normal importance
   - Should be addressed promptly
   - Takes precedence over low and normal priority tasks

4. **Urgent** (Red): Critical matters
   - Requires immediate attention
   - Should be completed as soon as possible

![Priority Levels](../images/priority-levels.png)

## Assignment Statistics

The Dashboard provides an overview of assignment statistics:

1. **Total Assignments**: All assignments in the system
2. **Active Assignments**: Currently active assignments
3. **Completed Assignments**: Successfully completed assignments
4. **Overdue Assignments**: Assignments past their due date

Additional statistics include:

- **Top Admins**: Admins with the most assignments
- **Assignment Types**: Breakdown by assignment type
- **Recent Assignments**: Latest assignments created

![Assignment Statistics](../images/assignment-stats.png)

## Troubleshooting

### Common Issues

1. **Assignment Not Showing Up**
   - Refresh the page
   - Check if you're viewing the correct status filter
   - Verify the assignment was created successfully

2. **Cannot Complete Assignment**
   - Ensure you have proper permissions
   - Check if the assignment is still active
   - Try refreshing the page

3. **Due Date Issues**
   - Ensure dates are entered in the correct format (YYYY-MM-DD)
   - The system uses your local time zone for due dates

### Support

If you encounter persistent issues with the assignment system:

1. Contact your system administrator
2. Email support@kso.org with details of the problem
3. Include screenshots and specific steps to reproduce the issue

---

*User Guide Updated: July 15, 2025*
