# Assignment Email Notification System

## Overview

The Assignment Email Notification System is designed to keep administrators informed about their assignments through automated email notifications. This system works in conjunction with the existing in-app notification system to provide comprehensive alerts and reminders.

## Features

1. **Status Update Notifications**
   - Sends emails when assignment status changes
   - Notifies both the assigned admin and the admin who created the assignment

2. **Upcoming Due Reminders**
   - Sends reminders for assignments due within the next 48 hours
   - Helps prevent assignments from becoming overdue

3. **Overdue Assignment Reminders**
   - Sends notifications for assignments that are past their due date
   - Repeats every 3 days until the assignment is completed or cancelled

4. **Inactive Assignment Alerts**
   - Identifies assignments with no activity for 7+ days
   - Sends reminders to the assigned admin
   - Escalates to supervisor after 14 days of inactivity

5. **Bulk Assignment Notifications**
   - Sends notifications when multiple assignments are created, updated, or deleted at once

## Email Templates

All emails use responsive HTML templates with consistent branding:

- **Assignment Notification**: Sent when a new assignment is created
- **Status Update Notification**: Sent when an assignment's status changes
- **Upcoming Due Reminder**: Sent when an assignment is due within 48 hours
- **Overdue Reminder**: Sent when an assignment is past its due date
- **Inactive Assignment Alert**: Sent when an assignment has no activity for 7+ days
- **Supervisor Escalation**: Sent to supervisors for assignments inactive for 14+ days
- **Bulk Assignment Notification**: Sent when multiple assignments are affected by a bulk action

## Configuration

Email notification settings can be configured in `config/email_config.php`:

```php
// Email settings
define('EMAIL_FROM', 'noreply@kso-chandigarh.org');
define('EMAIL_FROM_NAME', 'KSO Chandigarh Admin Panel');
define('EMAIL_REPLY_TO', 'support@kso-chandigarh.org');
define('SITE_NAME', 'KSO Chandigarh');
define('SITE_URL', 'https://admin.kso-chandigarh.org');

// Email debug mode (set to true to log emails instead of sending them)
define('EMAIL_DEBUG_MODE', false);

// Enable/disable specific notification types
define('ENABLE_ASSIGNMENT_NOTIFICATIONS', true);
define('ENABLE_ASSIGNMENT_REMINDERS', true);
define('ENABLE_SUPERVISOR_ESCALATIONS', true);
```

## Automated Reminders

Reminder emails are sent automatically via a scheduled task. The script `scripts/send_assignment_reminders.php` should be configured to run daily.

### Scheduling with Cron (Linux/Unix)

Add the following to your crontab to run the reminder script daily at 7 AM:

```
0 7 * * * php /path/to/public_html/adminlte/scripts/send_assignment_reminders.php >> /path/to/logs/reminders.log 2>&1
```

### Scheduling with Task Scheduler (Windows)

1. Open Task Scheduler
2. Create a new Basic Task
3. Set it to run daily at 7 AM
4. Action: Start a program
5. Program/script: `php`
6. Arguments: `C:\path\to\public_html\adminlte\scripts\send_assignment_reminders.php`

## Troubleshooting

Email logs are stored in `logs/email_log.txt` when `EMAIL_DEBUG_MODE` is enabled. This is useful for testing the notification system without actually sending emails.

If emails aren't being sent:

1. Check that the PHP mail function is properly configured on the server
2. Verify that the `ENABLE_ASSIGNMENT_NOTIFICATIONS` constant is set to `true`
3. Look for any errors in the PHP error log or email log
4. Ensure the script has permission to write to the logs directory

## Developer Reference

### Key Classes

- **EmailService**: Main service for sending all email notifications
- **AssignmentReminderService**: Identifies assignments needing reminders and sends appropriate notifications

### Adding New Notification Types

To add a new notification type:

1. Create a template function in `services/email/templates/reminder_templates.php`
2. Add a new method in the `EmailService` class
3. Update the relevant controller or service to call the new method when needed
