# Assignment System User Guide

## Introduction

The KSO Chandigarh Admin Panel Assignment System provides a comprehensive way to manage, track, and collaborate on member-related tasks. This guide explains how to use the system effectively.

## Accessing the Assignment Dashboard

1. Log in to the Admin Panel
2. Click on "Assignments" in the left sidebar
3. The dashboard provides an overview of all assignments and key statistics

## Dashboard Overview

The Assignment Dashboard consists of several sections:

### Assignment Statistics

At the top of the dashboard, you'll find cards showing:

- **Total Assignments**: Count of all assignments in the system
- **My Assignments**: Assignments specifically assigned to you
- **Pending**: Number of assignments awaiting completion
- **Completed**: Number of successfully completed assignments
- **Overdue**: Assignments that have passed their due date

### Assignment Distribution Chart

This pie chart shows the distribution of assignments by status (pending, completed, cancelled, etc.)

### Assignment Activity Feed

A real-time feed showing recent activity, including:

- New assignments created
- Status changes
- Comments and notes added
- Assignment completions

### Assignment Data Table

The main data table allows you to:

- View all assignments with filtering and sorting options
- Perform bulk actions
- Edit individual assignments
- Track status, priority, and deadlines

## Working with Assignments

### Creating a New Assignment

1. Click the "Create Assignment" button on the dashboard
2. Fill in the required fields:
   - **Member**: Select the member this assignment relates to
   - **Title**: Brief description of the assignment
   - **Description**: Detailed explanation of what needs to be done
   - **Assigned To**: The admin responsible for completing this task
   - **Priority**: Importance level (Low, Medium, High, Urgent)
   - **Due Date**: When the assignment should be completed
3. Click "Create Assignment" to save

### Updating Assignment Status

1. Find the assignment in the data table
2. Click the "Status" dropdown in the Actions column
3. Select the new status:
   - **Pending**: Assignment awaiting action
   - **In Progress**: Work has begun
   - **Completed**: Task is finished
   - **Cancelled**: Task is no longer needed
4. Add notes explaining the status change if required
5. Click "Update" to save

### Adding Notes to an Assignment

1. Click the "Notes" icon for the assignment
2. Enter your note in the text area
3. Click "Add Note" to save
4. Notes are timestamped and show who added them

### Using Bulk Actions

1. Check the boxes next to multiple assignments
2. Click the "Bulk Actions" dropdown
3. Select an action:
   - **Complete**: Mark all selected assignments as completed
   - **Cancel**: Cancel all selected assignments
   - **Reassign**: Change who is responsible for the assignments
   - **Delete**: Remove the assignments (admin only)
4. Confirm your action when prompted

## Notification System

The Assignment System includes comprehensive notifications:

### In-App Notifications

- Appear in the notification bell at the top of the screen
- Show recent assignment activity related to you
- Can be marked as read by clicking on them

### Email Notifications

Email notifications are sent for important events:

1. **New Assignment**: When you are assigned a new task
2. **Status Updates**: When an assignment's status changes
3. **Upcoming Due**: Reminder for assignments due within 48 hours
4. **Overdue**: Alert for assignments past their due date
5. **Inactive**: Reminder for assignments with no activity for 7+ days

## Advanced Features

### Filtering Assignments

1. Use the search box to find specific assignments
2. Click the "Filter" button to access advanced filtering options:
   - Filter by status, priority, date range, assigned person, etc.
   - Save frequently used filters for quick access

### Exporting Assignment Data

1. Filter the data table to show the assignments you want to export
2. Click the "Export" button
3. Choose your preferred format (Excel, CSV, PDF)
4. Download the file

### Setting Up Reminders

1. When creating or editing an assignment, check the "Send Reminders" box
2. Choose when reminders should be sent (1 day before, 2 days before, etc.)
3. Reminders will be sent automatically via email

## Best Practices

1. **Be Specific**: Write clear and detailed assignment descriptions
2. **Set Realistic Deadlines**: Allow sufficient time for completion
3. **Update Status Promptly**: Keep assignment status current
4. **Add Contextual Notes**: Include relevant information in notes
5. **Review Dashboard Regularly**: Check for new or overdue assignments daily

## Troubleshooting

### Common Issues

1. **Assignment Not Appearing**: Refresh the page or check your filters
2. **Can't Change Status**: Verify you have permission for that assignment
3. **No Email Notifications**: Check your spam folder or contact the system administrator

### Getting Help

If you encounter any issues with the Assignment System, please contact the system administrator or refer to the technical documentation in the Admin Guides section.
