# Assignment System Quick Reference Guide

## Overview

This quick reference guide outlines the updated assignment system for the KSO Chandigarh Admin Panel. The system has been refactored to align with the database schema, using the `admin_assignments` table.

## Database Table

```
admin_assignments
```

## Key Fields

| Field | Type | Description |
|-------|------|-------------|
| `id` | int | Primary key |
| `member_id` | int | ID of the assigned member |
| `assigned_to` | int | Admin ID the member is assigned to |
| `assigned_by` | int | Admin ID who created the assignment |
| `assignment_type` | enum | 'review', 'approval', 'verification', 'follow_up' |
| `priority` | enum | 'low', 'normal', 'high', 'urgent' |
| `status` | enum | 'active', 'completed', 'cancelled', 'overdue' |
| `due_date` | datetime | Optional due date |
| `notes` | text | Optional notes |
| `completed_at` | datetime | When the assignment was completed |
| `completed_by` | int | Admin ID who completed the assignment |

## API Endpoints

| Endpoint | Method | Purpose |
|----------|--------|---------|
| `/api/assignments/assign.php` | POST | Assign a member to an admin |
| `/api/assignments/unassign.php` | POST | Cancel or complete an assignment |
| `/api/assignments/list-assigned.php` | GET | List members assigned to an admin |
| `/api/assignments/list-member.php` | GET | List assignments for a member |
| `/api/assignments/transfer.php` | POST | Transfer assignments between admins |
| `/api/assignments/stats.php` | GET | Get assignment statistics |

## Frontend Functions

| Function | Purpose |
|----------|---------|
| `AssignmentSystem.init()` | Initialize the assignment system |
| `AssignmentSystem.assignMember()` | Assign a member to an admin |
| `AssignmentSystem.unassignMember()` | Cancel or complete an assignment |
| `AssignmentSystem.transferAssignments()` | Transfer assignments between admins |
| `AssignmentSystem.loadMemberAssignments()` | Load assignments for a member |
| `AssignmentSystem.loadAssignedMembers()` | Load members assigned to an admin |
| `AssignmentSystem.loadAssignmentStats()` | Load assignment statistics |

## HTML Containers

| Container ID | Purpose |
|--------------|---------|
| `member-assignments-container` | Display assignments for a member |
| `assigned-members-container` | Display members assigned to an admin |
| `assignment-stats` | Display assignment statistics |

## Example Usage

### Assign a Member

```javascript
AssignmentSystem.assignMember(
  memberId,               // Member ID
  adminId,                // Admin ID
  'review',               // Assignment type
  'normal',               // Priority
  'Additional notes...',  // Notes
  '2025-08-15 17:00:00'   // Due date
);
```

### Cancel an Assignment

```javascript
AssignmentSystem.unassignMember(
  assignmentId,           // Assignment ID
  'No longer needed',     // Reason
  'cancelled'             // Status
);
```

### Complete an Assignment

```javascript
AssignmentSystem.unassignMember(
  assignmentId,           // Assignment ID
  'Verification complete', // Reason
  'completed'             // Status
);
```

### Display Assignments

```javascript
// For a member profile page
AssignmentSystem.loadMemberAssignments(memberId);

// For an admin dashboard
AssignmentSystem.loadAssignedMembers(adminId, 'active');

// For statistics dashboard
AssignmentSystem.loadAssignmentStats();
```

## Color Coding

### Status Colors

| Status | Badge Class | Color |
|--------|-------------|-------|
| active | badge-success | Green |
| completed | badge-info | Blue |
| cancelled | badge-secondary | Gray |
| overdue | badge-danger | Red |

### Priority Colors

| Priority | Badge Class | Color |
|----------|-------------|-------|
| low | badge-secondary | Gray |
| normal | badge-info | Blue |
| high | badge-warning | Yellow/Orange |
| urgent | badge-danger | Red |

## Implementation Notes

1. All assignments are now to admins only (no group assignments)
2. Status changes require an admin ID for tracking
3. Due dates are optional but recommended
4. Assignment type and priority are required

---

*Last updated: July 15, 2025*
