# Assignment Reminder Scheduled Task for Windows
# This PowerShell script creates a scheduled task to run the assignment reminder script daily at 7 AM

# Define script path
$scriptPath = "C:\Users\samue\OneDrive\Documents\public_html\adminlte\scripts\send_assignment_reminders.php"
$phpPath = "php" # Assumes PHP is in your PATH

# Define the task action
$action = New-ScheduledTaskAction -Execute $phpPath -Argument $scriptPath

# Set the trigger to run daily at 7 AM
$trigger = New-ScheduledTaskTrigger -Daily -At 7am

# Set task settings
$settings = New-ScheduledTaskSettingsSet -StartWhenAvailable -DontStopOnIdleEnd -AllowStartIfOnBatteries -DontStopIfGoingOnBatteries

# Register the task
Register-ScheduledTask -TaskName "KSO Assignment Reminders" -Action $action -Trigger $trigger -Settings $settings -Description "Sends daily assignment reminder emails for the KSO Admin Panel" -RunLevel Highest -Force

Write-Host "Scheduled task 'KSO Assignment Reminders' has been created to run daily at 7 AM." -ForegroundColor Green
Write-Host "You can view and modify this task in Task Scheduler."
