<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-dark-primary elevation-4" style="width: 250px;">
    <!-- Custom sidebar styles -->
    <style>
        /* Enhanced sidebar styling for professional look */
        .main-sidebar {
            background: linear-gradient(180deg, #2c3e50 0%, #1a2530 100%) !important;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2) !important;
        }
        
        /* Brand/logo area styling */
        .brand-link {
            background-color: rgba(0, 0, 0, 0.1) !important;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1) !important;
        }
        
        /* User panel enhancements */
        .user-panel {
            background-color: rgba(0, 0, 0, 0.05) !important;
            border-bottom: 1px solid rgba(255, 255, 255, 0.07) !important;
            margin-bottom: 12px !important;
        }
        
        .user-panel .image img {
            transition: all 0.2s ease;
        }
        
        .user-panel .image img:hover {
            transform: scale(1.05);
            border-color: rgba(255, 255, 255, 0.4) !important;
        }
        
        /* Reduce all nav-link padding and margins */
        .sidebar .nav-link {
            padding: 10px 15px !important;
            border-radius: 6px !important;
            margin: 0 8px !important;
            transition: all 0.2s ease !important;
        }
        
        .sidebar .nav-link:hover {
            background-color: rgba(255, 255, 255, 0.1) !important;
        }
        
        .sidebar .nav-link.active {
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2) !important;
        }
        
        /* Reduce icon sizes */
        .sidebar .nav-icon {
            font-size: 1rem !important;
            width: 20px !important;
        }
        
        /* Adjust icon margin */
        .sidebar .nav-link p {
            margin-left: 8px !important;
        }
        
        /* Reduce submenus padding */
        .sidebar .nav-treeview {
            padding-left: 15px !important;
            margin-top: 3px !important;
        }
        
        /* Adjust submenu items */
        .sidebar .nav-treeview .nav-link {
            padding: 7px 12px !important;
            margin: 2px 6px !important;
        }
        
        /* Adjust section headers */
        .sidebar .nav-header {
            padding: 7px 15px !important;
            font-size: 0.7rem !important;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: rgba(255, 255, 255, 0.4) !important;
        }
    </style>
    
    <!-- Brand Logo -->
    <a href="index.php" class="brand-link" style="padding: 12px 15px;">
        <img src="dist/img/kso-logo.png" alt="KUKI STUDENTS' ORGANISATION Logo" class="brand-image img-circle elevation-3" style="opacity: .9; width: 38px; height: 38px; object-fit: contain; background-color: #fff; padding: 3px;">
        <span class="brand-text font-weight-bold ml-2" style="font-size: 0.9rem;">KUKI STUDENTS' ORG</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar" style="padding-top: 8px;">
        <!-- Sidebar user panel -->
        <div class="user-panel mt-2 pb-2 mb-3 d-flex border-bottom">
            <div class="image">
                <?php
                // Get admin photo if available
                $admin_photo = '';
                if (isset($_SESSION['admin_id'])) {
                    try {
                        $pdo = getDBConnection();
                        $stmt = $pdo->prepare("SELECT photo_url FROM admins WHERE id = ?");
                        $stmt->execute([$_SESSION['admin_id']]);
                        $result = $stmt->fetch();
                        if ($result && !empty($result['photo_url'])) {
                            $admin_photo = $result['photo_url'];
                        }
                    } catch (Exception $e) {
                        // Silently fail and use default image
                    }
                }
                ?>
                <img src="<?php echo !empty($admin_photo) ? htmlspecialchars($admin_photo) : 'dist/img/user-default.jpg'; ?>" 
                     class="img-circle elevation-2" alt="User Image" 
                     style="width: 40px; height: 40px; object-fit: cover; border: 2px solid rgba(255,255,255,0.2);">
            </div>
            <div class="info ml-2">
                <a href="profile.php" class="d-block text-white" style="line-height: 1.2;">
                    <span style="font-size: 0.9rem; font-weight: 500;">
                        <?php echo $_SESSION['admin_name'] ?? 'Admin User'; ?>
                    </span>
                    <small class="text-light d-block" style="font-size: 0.8rem; opacity: 0.8;">
                        <?php echo $_SESSION['admin_role'] ?? 'Administrator'; ?>
                    </small>
                </a>
            </div>
        </div>

        <!-- Sidebar Search -->
        <div class="form-inline mb-2" style="padding: 0 10px;">
            <div class="input-group w-100" data-widget="sidebar-search">
                <input class="form-control form-control-sidebar bg-dark border-0" type="search" placeholder="Search..." aria-label="Search" style="border-radius: 20px 0 0 20px; font-size: 0.85rem;">
                <div class="input-group-append">
                    <button class="btn btn-sidebar bg-dark border-0" style="border-radius: 0 20px 20px 0;">
                        <i class="fas fa-search fa-fw"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="true" style="font-size: 0.85rem;">
                
                <!-- Dashboard -->
                <li class="nav-item mb-1">
                    <a href="index.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'index.php') ? 'active' : ''; ?>" style="padding: 10px 15px; border-radius: 6px; margin: 0 8px;">
                        <i class="nav-icon fas fa-tachometer-alt text-info" style="font-size: 1rem; width: 20px;"></i>
                        <p style="margin-left: 8px; font-weight: 500;">Dashboard</p>
                    </a>
                </li>

                <!-- Main Sections Header -->
                <li class="nav-header mt-2 mb-1" style="padding: 7px 15px; font-size: 0.7rem; font-weight: 600; color: #adb5bd;">
                    <i class="fas fa-layer-group mr-1"></i> MAIN MODULES
                </li>

                <!-- Members Management -->
                <li class="nav-item mb-1 <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['members.php', 'member-registration.php', 'member-approval.php', 'membership-fees.php', 'membership-renewal.php'])) ? 'menu-open' : ''; ?>">
                    <a href="#" class="nav-link <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['members.php', 'member-registration.php', 'member-approval.php', 'membership-fees.php', 'membership-renewal.php'])) ? 'active' : ''; ?>" style="padding: 12px 20px; border-radius: 8px; margin: 0 10px;">
                        <i class="nav-icon fas fa-users text-success" style="font-size: 1.1rem; width: 25px;"></i>
                        <p style="margin-left: 10px; font-weight: 500;">
                            Members Management
                            <i class="fas fa-angle-left right" style="margin-top: 2px;"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview" style="padding-left: 20px; margin-top: 5px;">
                        <li class="nav-item">
                            <a href="members.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'members.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-users nav-icon text-primary" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">All Members</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="member-registration.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'member-registration.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-user-plus nav-icon text-warning" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Add New Member</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="member-approval.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'member-approval.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-user-check nav-icon text-danger" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">
                                    Pending Approvals
                                </p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="membership-fees.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'membership-fees.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-rupee-sign nav-icon text-success" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Membership Fees</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="membership-renewal.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'membership-renewal.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-redo nav-icon text-info" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">
                                    Renewals
                                </p>
                            </a>
                        </li>
                    </ul>
                </li>
                
                <!-- Assignments -->
                <li class="nav-item mb-1 <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['assignments.php'])) ? 'menu-open' : ''; ?>">
                    <a href="assignments.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'assignments.php') ? 'active' : ''; ?>" style="padding: 12px 20px; border-radius: 8px; margin: 0 10px;">
                        <i class="nav-icon fas fa-tasks"></i>
                        <p>
                            Assignments
                            <?php
                            // Count pending assignments for current admin
                            require_once __DIR__ . '/../services/assignment/AssignmentService.php';
                            $assignmentService = new \Services\Assignment\AssignmentService();
                            $pendingCount = $assignmentService->countPendingAssignmentsForAdmin($_SESSION['admin_id']);
                            if ($pendingCount > 0) {
                                echo '<span class="badge badge-danger right">' . $pendingCount . '</span>';
                            }
                            ?>
                        </p>
                    </a>
                </li>

                <!-- Events Management -->
                <li class="nav-item mb-1 <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['events.php', 'event-calendar.php', 'event-registrations.php', 'event-attendance.php'])) ? 'menu-open' : ''; ?>">
                    <a href="#" class="nav-link <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['events.php', 'event-calendar.php', 'event-registrations.php', 'event-attendance.php'])) ? 'active' : ''; ?>" style="padding: 12px 20px; border-radius: 8px; margin: 0 10px;">
                        <i class="nav-icon fas fa-calendar-alt text-purple" style="font-size: 1.1rem; width: 25px;"></i>
                        <p style="margin-left: 10px; font-weight: 500;">
                            Events Management
                            <i class="fas fa-angle-left right" style="margin-top: 2px;"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview" style="padding-left: 20px; margin-top: 5px;">
                        <li class="nav-item">
                            <a href="events.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'events.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-calendar nav-icon text-purple" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">All Events</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="event-calendar.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'event-calendar.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-calendar-week nav-icon text-info" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Event Calendar</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="event-registrations.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'event-registrations.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-clipboard-list nav-icon text-warning" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Registrations</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="event-attendance.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'event-attendance.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-user-check nav-icon text-success" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Attendance</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Finance Management -->
                <li class="nav-item mb-1 <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['finance.php', 'expenses.php', 'receipts.php', 'financial-reports.php'])) ? 'menu-open' : ''; ?>">
                    <a href="#" class="nav-link <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['finance.php', 'expenses.php', 'receipts.php', 'financial-reports.php'])) ? 'active' : ''; ?>" style="padding: 12px 20px; border-radius: 8px; margin: 0 10px;">
                        <i class="nav-icon fas fa-coins text-warning" style="font-size: 1.1rem; width: 25px;"></i>
                        <p style="margin-left: 10px; font-weight: 500;">
                            Finance Management
                            <i class="fas fa-angle-left right" style="margin-top: 2px;"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview" style="padding-left: 20px; margin-top: 5px;">
                        <li class="nav-item">
                            <a href="finance.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'finance.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-exchange-alt nav-icon text-success" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Transactions</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="expenses.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'expenses.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-money-bill-wave nav-icon text-danger" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Expenses</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="receipts.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'receipts.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-receipt nav-icon text-info" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Receipts & Invoices</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="financial-reports.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'financial-reports.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-chart-pie nav-icon text-warning" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Financial Reports</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Documents & Communications Header -->
                <li class="nav-header mt-3 mb-1" style="padding: 7px 15px; font-size: 0.7rem; font-weight: 600; color: #adb5bd;">
                    <i class="fas fa-file-alt mr-1"></i> DOCUMENTS & COMMUNICATION
                </li>

                <!-- Documents & ID Cards -->
                <li class="nav-item mb-1 <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['documents.php', 'id-cards.php', 'email-templates.php'])) ? 'menu-open' : ''; ?>">
                    <a href="#" class="nav-link <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['documents.php', 'id-cards.php', 'email-templates.php'])) ? 'active' : ''; ?>" style="padding: 12px 20px; border-radius: 8px; margin: 0 10px;">
                        <i class="nav-icon fas fa-folder-open text-primary" style="font-size: 1.1rem; width: 25px;"></i>
                        <p style="margin-left: 10px; font-weight: 500;">
                            Documents & Templates
                            <i class="fas fa-angle-left right" style="margin-top: 2px;"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview" style="padding-left: 20px; margin-top: 5px;">
                        <li class="nav-item">
                            <a href="documents.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'documents.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-file-alt nav-icon text-primary" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Document Library</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="id-cards.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'id-cards.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-id-card nav-icon text-warning" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">ID Cards</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="email-templates.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'email-templates.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-envelope-open nav-icon text-info" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Email Templates</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Communications -->
                <li class="nav-item mb-1 <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['notifications.php', 'email-campaigns.php', 'email-logs.php'])) ? 'menu-open' : ''; ?>">
                    <a href="#" class="nav-link <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['notifications.php', 'email-campaigns.php', 'email-logs.php'])) ? 'active' : ''; ?>" style="padding: 12px 20px; border-radius: 8px; margin: 0 10px;">
                        <i class="nav-icon fas fa-bullhorn text-danger" style="font-size: 1.1rem; width: 25px;"></i>
                        <p style="margin-left: 10px; font-weight: 500;">
                            Communications
                            <i class="fas fa-angle-left right" style="margin-top: 2px;"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview" style="padding-left: 20px; margin-top: 5px;">
                        <li class="nav-item">
                            <a href="notifications.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'notifications.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-bell nav-icon text-danger" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">
                                    Notifications
                                </p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="email-campaigns.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'email-campaigns.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-paper-plane nav-icon text-success" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Email Campaigns</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="email-logs.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'email-logs.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-list-alt nav-icon text-info" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Email Logs</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Reports & Analytics -->
                <li class="nav-item mb-1 <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['reports.php', 'member-reports.php', 'event-reports.php', 'attendance-reports.php'])) ? 'menu-open' : ''; ?>">
                    <a href="#" class="nav-link <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['reports.php', 'member-reports.php', 'event-reports.php', 'attendance-reports.php'])) ? 'active' : ''; ?>" style="padding: 12px 20px; border-radius: 8px; margin: 0 10px;">
                        <i class="nav-icon fas fa-chart-line text-success" style="font-size: 1.1rem; width: 25px;"></i>
                        <p style="margin-left: 10px; font-weight: 500;">
                            Reports & Analytics
                            <i class="fas fa-angle-left right" style="margin-top: 2px;"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview" style="padding-left: 20px; margin-top: 5px;">
                        <li class="nav-item">
                            <a href="reports.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'reports.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-tachometer-alt nav-icon text-primary" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Dashboard Reports</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="member-reports.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'member-reports.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-users nav-icon text-success" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Member Reports</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="event-reports.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'event-reports.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-calendar-alt nav-icon text-purple" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Event Reports</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="attendance-reports.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'attendance-reports.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-clipboard-check nav-icon text-warning" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Attendance Reports</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- System Management Header -->
                <li class="nav-header mt-3 mb-1" style="padding: 7px 15px; font-size: 0.7rem; font-weight: 600; color: #adb5bd;">
                    <i class="fas fa-cogs mr-1"></i> SYSTEM MANAGEMENT
                </li>

                <!-- Admin Management -->
                <li class="nav-item mb-1 <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['admins.php', 'admin-roles.php', 'security-monitoring.php'])) ? 'menu-open' : ''; ?>">
                    <a href="#" class="nav-link <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['admins.php', 'admin-roles.php', 'security-monitoring.php'])) ? 'active' : ''; ?>" style="padding: 12px 20px; border-radius: 8px; margin: 0 10px;">
                        <i class="nav-icon fas fa-user-shield text-danger" style="font-size: 1.1rem; width: 25px;"></i>
                        <p style="margin-left: 10px; font-weight: 500;">
                            Admin Management
                            <i class="fas fa-angle-left right" style="margin-top: 2px;"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview" style="padding-left: 20px; margin-top: 5px;">
                        <li class="nav-item">
                            <a href="admins.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'admins.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-users-cog nav-icon text-danger" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">All Admins</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="admin-roles.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'admin-roles.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-key nav-icon text-warning" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Roles & Permissions</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="security-monitoring.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'security-monitoring.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-shield-alt nav-icon text-info" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Security Monitoring</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- System Settings -->
                <li class="nav-item mb-1 <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['settings.php', 'membership-settings.php', 'system-logs.php', 'backup-restore.php'])) ? 'menu-open' : ''; ?>">
                    <a href="#" class="nav-link <?php echo (in_array(basename($_SERVER['PHP_SELF']), ['settings.php', 'membership-settings.php', 'system-logs.php', 'backup-restore.php'])) ? 'active' : ''; ?>" style="padding: 12px 20px; border-radius: 8px; margin: 0 10px;">
                        <i class="nav-icon fas fa-cogs text-secondary" style="font-size: 1.1rem; width: 25px;"></i>
                        <p style="margin-left: 10px; font-weight: 500;">
                            System Settings
                            <i class="fas fa-angle-left right" style="margin-top: 2px;"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview" style="padding-left: 20px; margin-top: 5px;">
                        <li class="nav-item">
                            <a href="settings.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'settings.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-sliders-h nav-icon text-primary" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">General Settings</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="membership-settings.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'membership-settings.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-id-card nav-icon text-success" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Membership Settings</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="system-logs.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'system-logs.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-file-alt nav-icon text-warning" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">System Logs</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="backup-restore.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'backup-restore.php') ? 'active' : ''; ?>" style="padding: 8px 15px; border-radius: 6px; margin: 2px 10px;">
                                <i class="fas fa-database nav-icon text-info" style="font-size: 0.9rem; width: 20px;"></i>
                                <p style="margin-left: 8px;">Backup & Restore</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Activity & Logs -->
                <li class="nav-item mb-2">
                    <a href="activity-logs.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'activity-logs.php') ? 'active' : ''; ?>" style="padding: 12px 20px; border-radius: 8px; margin: 0 10px;">
                        <i class="nav-icon fas fa-history text-muted" style="font-size: 1.1rem; width: 25px;"></i>
                        <p style="margin-left: 10px; font-weight: 500;">
                            Activity Logs
                        </p>
                    </a>
                </li>

                <!-- Account Section Header -->
                <li class="nav-header mt-3 mb-1" style="padding: 7px 15px; font-size: 0.7rem; font-weight: 600; color: #adb5bd;">
                    <i class="fas fa-user mr-1"></i> ACCOUNT
                </li>

                <!-- Profile -->
                <li class="nav-item mb-1">
                    <a href="profile.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'profile.php') ? 'active' : ''; ?>">
                        <i class="nav-icon fas fa-user-circle text-info" style="font-size: 1.1rem; width: 25px;"></i>
                        <p style="margin-left: 10px; font-weight: 500;">My Profile</p>
                    </a>
                </li>

                <!-- Logout -->
                <li class="nav-item mb-3">
                    <a href="auth/logout.php" class="nav-link" style="padding: 12px 20px; border-radius: 8px; margin: 0 10px; background: rgba(220, 53, 69, 0.1);">
                        <i class="nav-icon fas fa-sign-out-alt text-danger" style="font-size: 1.1rem; width: 25px;"></i>
                        <p style="margin-left: 10px; font-weight: 500; color: #dc3545;">Logout</p>
                    </a>
                </li>
            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>
