<?php
echo "Creating admin test data...\n";

try {
    $pdo = new PDO('mysql:host=localhost;dbname=ktxmmosu_kso_chandigarh', 'root', '', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);

    // Create admin with a simple password
    $password = 'admin123';
    $password_hash = password_hash($password, PASSWORD_DEFAULT);
    
    // Check if admin already exists
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM admins WHERE username = ?");
    $stmt->execute(['admin']);
    $exists = $stmt->fetch()['count'] > 0;
    
    if (!$exists) {
        // Insert admin user
        $stmt = $pdo->prepare("
            INSERT INTO admins (
                kso_id, first_name, last_name, nickname, username, email, password_hash, 
                role, term_from_year, term_to_year, status, phone, college, course, 
                year_of_study, notes, created_at, updated_at
            ) VALUES (
                'KSOCHD001', 'Admin', 'User', 'Admin', 'admin', 'admin@ksochandigarh.com', ?, 
                'President', 2024, 2025, 'active', '555-0100', 'KSO Admin', 'Administration', 
                0, 'Test Admin Account', NOW(), NOW()
            )
        ");
        $stmt->execute([$password_hash]);
        
        echo "✅ Admin user created successfully!\n";
        echo "Username: admin\n";
        echo "Password: admin123\n";
        echo "Email: admin@ksochandigarh.com\n";
        echo "Role: President\n";
    } else {
        echo "ℹ️  Admin user already exists, updating password...\n";
        
        // Update password
        $stmt = $pdo->prepare("UPDATE admins SET password_hash = ? WHERE username = 'admin'");
        $stmt->execute([$password_hash]);
        
        echo "✅ Admin password updated!\n";
        echo "Username: admin\n";
        echo "Password: admin123\n";
    }
    
    // Verify the admin was created/updated
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM admins");
    $result = $stmt->fetch();
    echo "\nTotal admin records: " . $result['count'] . "\n";
    
    // Show all admins
    $stmt = $pdo->query("SELECT username, email, role, status FROM admins");
    $admins = $stmt->fetchAll();
    
    echo "\nAvailable admin accounts:\n";
    foreach ($admins as $admin) {
        echo "  - {$admin['username']} ({$admin['email']}) - {$admin['role']} - {$admin['status']}\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
