<?php
// Create missing admin_sessions table for KSO Chandigarh system
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection details
$host = 'localhost';
$username = 'ktxmmosu_kso_db';
$password = 'KSO@2025';
$database = 'ktxmmosu_kso_chandigarh';

try {
    $conn = new mysqli($host, $username, $password, $database);
    
    if ($conn->connect_error) {
        die('Connection failed: ' . $conn->connect_error);
    }
    
    echo "Connected successfully to database: $database\n";
    
    // Check if admin_sessions table exists
    $check_table = "SHOW TABLES LIKE 'admin_sessions'";
    $result = $conn->query($check_table);
    
    if ($result->num_rows > 0) {
        echo "admin_sessions table already exists.\n";
    } else {
        echo "Creating admin_sessions table...\n";
        
        // Create the admin_sessions table
        $sql = "CREATE TABLE IF NOT EXISTS `admin_sessions` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `admin_id` int(11) NOT NULL,
          `token` varchar(64) NOT NULL,
          `expires_at` datetime NOT NULL,
          `ip_address` varchar(45) DEFAULT NULL,
          `user_agent` text DEFAULT NULL,
          `created_at` datetime DEFAULT current_timestamp(),
          `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
          PRIMARY KEY (`id`),
          UNIQUE KEY `token` (`token`),
          KEY `admin_id` (`admin_id`),
          KEY `expires_at` (`expires_at`),
          CONSTRAINT `admin_sessions_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `admins` (`id`) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
        
        if ($conn->query($sql) === TRUE) {
            echo "admin_sessions table created successfully!\n";
        } else {
            echo "Error creating table: " . $conn->error . "\n";
        }
    }
    
    // Verify the table structure
    echo "\nTable structure:\n";
    $describe = $conn->query("DESCRIBE admin_sessions");
    if ($describe) {
        while ($row = $describe->fetch_assoc()) {
            echo sprintf("%-15s %-20s %-8s %-5s %-10s %s\n", 
                $row['Field'], $row['Type'], $row['Null'], 
                $row['Key'], $row['Default'], $row['Extra']);
        }
    }
    
    $conn->close();
    echo "\nTable creation completed successfully!\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
