# Clean URL System Documentation

## Overview

The KSO Chandigarh Admin Panel now implements a clean URL system that hides file extensions, making URLs more user-friendly and SEO-friendly. For example, instead of `http://example.com/adminlte/assignments.php`, users can now access `http://example.com/adminlte/assignments`.

## Implementation

The clean URL system is implemented using three main components:

1. **`.htaccess` Files**: Apache configuration files that handle URL rewriting
2. **Initialization Files**: PHP scripts that ensure links are properly formatted
3. **Helper Functions**: Utility functions to generate and manage clean URLs

## Setup

The system is already set up and should work automatically. If you're deploying to a new server, ensure that:

1. Apache's `mod_rewrite` module is enabled
2. AllowOverride is set to All in your Apache configuration
3. The `.htaccess` files are properly uploaded

## Files

### `.htaccess` Files

1. **Root `.htaccess`** (`/public_html/.htaccess`):
   - Handles site-wide URL rewriting
   - Prevents access to sensitive directories
   - Sets security headers and PHP configuration

2. **AdminLTE `.htaccess`** (`/public_html/adminlte/.htaccess`):
   - Handles URL rewriting specifically for the admin section
   - Configures caching for static assets
   - Sets appropriate security measures

### Initialization Files

1. **Main Initialization** (`/public_html/init.php`):
   - Defines base URL constants
   - Provides helper functions for clean URLs
   - Tests if URL rewriting is working

2. **AdminLTE Initialization** (`/public_html/adminlte/init.php`):
   - Extends the main initialization for admin-specific needs
   - Manages DataTables AJAX URLs
   - Adds canonical links to prevent duplicate content issues

## Usage

### Including Initialization Files

Include the appropriate initialization file at the top of your PHP scripts:

```php
// For main site pages
require_once __DIR__ . '/init.php';

// For AdminLTE pages
require_once __DIR__ . '/init.php';
```

### Generating Clean URLs

Use the provided helper functions to generate URLs:

```php
// Generate a clean URL for an admin page
$url = adminUrl('assignments', ['filter' => 'pending']);
// Result: http://example.com/adminlte/assignments?filter=pending

// Generate an API URL
$apiUrl = apiUrl('assignments/stats.php');
// Result: http://example.com/adminlte/api/assignments/stats.php (API URLs still use .php)
```

### Updating Templates

The initialization system automatically updates links in HTML output, but for best results:

1. Use the helper functions to generate URLs
2. Avoid hardcoding `.php` extensions in templates
3. For AJAX calls, use the `apiUrl()` function

## Debugging

If clean URLs are not working:

1. Check if mod_rewrite is enabled:
   ```
   apache2ctl -M | grep rewrite
   ```

2. Verify .htaccess files are being processed:
   ```
   <Directory "/var/www/html">
       AllowOverride All
   </Directory>
   ```

3. Test URL rewriting with the built-in function:
   ```php
   if (isRewriteEnabled()) {
       echo "URL rewriting is working!";
   } else {
       echo "URL rewriting is NOT working!";
   }
   ```

## Important Notes

1. **API Endpoints**: API endpoints still use `.php` extensions for compatibility
2. **DataTables**: DataTables AJAX URLs are automatically patched to work with clean URLs
3. **Form Actions**: Always use the `adminUrl()` function for form actions
4. **JavaScript**: Update any hardcoded URLs in JavaScript to use clean URLs

## Canonical URLs

To prevent duplicate content issues (both `/page` and `/page.php` being accessible), the system adds canonical links to all pages. This tells search engines which URL is the preferred version.

## Maintenance

When adding new pages or features:

1. Use the provided helper functions for generating URLs
2. Include the appropriate initialization file at the top of new PHP scripts
3. Test both with and without file extensions to ensure everything works correctly
