<?php
echo "Importing SQL schema...\n";

try {
    $pdo = new PDO('mysql:host=localhost;dbname=ktxmmosu_kso_chandigarh', 'root', '', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);

    // Read the SQL file
    $sql_file = 'access/data/database/ktxmmosu_kso_chandigarh.sql';
    
    if (!file_exists($sql_file)) {
        echo "❌ SQL file not found: $sql_file\n";
        exit(1);
    }
    
    $sql = file_get_contents($sql_file);
    
    // Split into individual statements and clean them
    $statements = array_filter(array_map('trim', preg_split('/;\s*$/m', $sql)));
    
    $success = 0;
    $errors = 0;

    foreach ($statements as $statement) {
        // Skip empty statements and comments
        if (empty($statement) || 
            strpos($statement, '--') === 0 || 
            strpos($statement, '/*') === 0 ||
            strpos($statement, '/*!') === 0) {
            continue;
        }
        
        try {
            $pdo->exec($statement);
            $success++;
        } catch (Exception $e) {
            $errors++;
            echo "Warning: " . $e->getMessage() . "\n";
        }
    }

    echo "✅ Import completed: $success statements executed, $errors warnings\n";
    
    // Verify import
    $stmt = $pdo->query('SELECT COUNT(*) as count FROM admins');
    $result = $stmt->fetch();
    echo "Admin records after import: " . $result['count'] . "\n";
    
} catch (Exception $e) {
    echo "❌ Import failed: " . $e->getMessage() . "\n";
}
?>
