<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Session Debug Information</h2>";
echo "<h3>Session Data:</h3>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

echo "<h3>Session ID:</h3>";
echo session_id();

echo "<h3>Session Status:</h3>";
echo session_status();

echo "<h3>Cookie Data:</h3>";
echo "<pre>";
print_r($_COOKIE);
echo "</pre>";

echo "<h3>Session Settings:</h3>";
echo "Session name: " . session_name() . "<br>";
echo "Session save path: " . session_save_path() . "<br>";
echo "Session cookie lifetime: " . session_get_cookie_params()['lifetime'] . "<br>";
echo "Session cookie path: " . session_get_cookie_params()['path'] . "<br>";
echo "Session cookie domain: " . session_get_cookie_params()['domain'] . "<br>";

echo "<h3>Authentication Check:</h3>";
require_once 'adminlte/config/database.php';

if (function_exists('checkAuthentication')) {
    $auth_result = checkAuthentication();
    echo "Authentication result: " . ($auth_result ? "TRUE" : "FALSE") . "<br>";
} else {
    echo "checkAuthentication function not found<br>";
}

echo "<h3>Current Time:</h3>";
echo date('Y-m-d H:i:s');
?>
