<?php
// Database connection test for KSO Chandigarh

echo "<h2>Testing Database Connections</h2>";

// Test 1: Current credentials
echo "<h3>Test 1: ktxmmosu_kso_db / KSO@2025</h3>";
try {
    $pdo1 = new PDO("mysql:host=localhost;dbname=ktxmmosu_kso_chandigarh;charset=utf8mb4", 'ktxmmosu_kso_db', 'KSO@2025');
    echo "✅ SUCCESS: Connected with ktxmmosu_kso_db / KSO@2025<br>";
    
    // Test query
    $stmt = $pdo1->query("SELECT COUNT(*) as count FROM admins");
    $result = $stmt->fetch();
    echo "📊 Admins in database: " . $result['count'] . "<br>";
} catch (Exception $e) {
    echo "❌ FAILED: " . $e->getMessage() . "<br>";
}

echo "<br>";

// Test 2: Alternative credentials
echo "<h3>Test 2: ktxmmosu_kso_db / Admin@123</h3>";
try {
    $pdo2 = new PDO("mysql:host=localhost;dbname=ktxmmosu_kso_chandigarh;charset=utf8mb4", 'ktxmmosu_kso_db', 'Admin@123');
    echo "✅ SUCCESS: Connected with ktxmmosu_kso_db / Admin@123<br>";
} catch (Exception $e) {
    echo "❌ FAILED: " . $e->getMessage() . "<br>";
}

echo "<br>";

// Test 3: Root credentials
echo "<h3>Test 3: root / (empty)</h3>";
try {
    $pdo3 = new PDO("mysql:host=localhost;dbname=ktxmmosu_kso_chandigarh;charset=utf8mb4", 'root', '');
    echo "✅ SUCCESS: Connected with root / (empty)<br>";
} catch (Exception $e) {
    echo "❌ FAILED: " . $e->getMessage() . "<br>";
}

echo "<br>";

// Test 4: Root with password
echo "<h3>Test 4: root / KSO@2025</h3>";
try {
    $pdo4 = new PDO("mysql:host=localhost;dbname=ktxmmosu_kso_chandigarh;charset=utf8mb4", 'root', 'KSO@2025');
    echo "✅ SUCCESS: Connected with root / KSO@2025<br>";
} catch (Exception $e) {
    echo "❌ FAILED: " . $e->getMessage() . "<br>";
}
?>
