<?php
/**
 * Clean URL System Test
 * 
 * This script tests if the clean URL system is working correctly.
 * It attempts to access various URLs with and without .php extension
 * and reports the results.
 */

// Include the initialization file
require_once __DIR__ . '/init.php';

// Define the URLs to test
$testUrls = [
    BASE_URL . '/adminlte/dashboard',
    BASE_URL . '/adminlte/members',
    BASE_URL . '/adminlte/assignments',
    BASE_URL . '/adminlte/events',
    BASE_URL . '/adminlte/finance'
];

// Test function
function testUrl($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, false);
    curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return $httpCode;
}

// Start the test
echo "<!DOCTYPE html>
<html>
<head>
    <title>Clean URL System Test</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; padding: 20px; }
        h1 { color: #3c8dbc; }
        table { border-collapse: collapse; width: 100%; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 12px; text-align: left; }
        th { background-color: #f5f5f5; }
        .success { color: green; }
        .error { color: red; }
        .info { background-color: #f0f7ff; padding: 15px; border-left: 5px solid #3c8dbc; margin-bottom: 20px; }
    </style>
</head>
<body>
    <h1>Clean URL System Test</h1>
    
    <div class='info'>
        <p>This test checks if the clean URL system is working correctly. It attempts to access several URLs with and without the .php extension and reports the HTTP status code for each.</p>
        <p>A status code of 200 indicates that the URL is accessible.</p>
    </div>
    
    <table>
        <tr>
            <th>URL</th>
            <th>Status Code</th>
            <th>Result</th>
        </tr>";

// Test each URL
foreach ($testUrls as $url) {
    $statusCode = testUrl($url);
    $phpUrl = $url . '.php';
    $phpStatusCode = testUrl($phpUrl);
    
    $result = ($statusCode === 200) ? 'Success' : 'Failed';
    $resultClass = ($statusCode === 200) ? 'success' : 'error';
    
    echo "<tr>
            <td>$url</td>
            <td>$statusCode</td>
            <td class='$resultClass'>$result</td>
          </tr>";
          
    echo "<tr>
            <td>$phpUrl</td>
            <td>$phpStatusCode</td>
            <td class='" . (($phpStatusCode === 200) ? 'success' : 'error') . "'>" . 
            (($phpStatusCode === 200) ? 'Success' : 'Failed') . "</td>
          </tr>";
}

// Test mod_rewrite
echo "<tr>
        <th colspan='3'>mod_rewrite Test</th>
      </tr>";

$rewriteEnabled = isRewriteEnabled();
echo "<tr>
        <td colspan='2'>mod_rewrite Enabled</td>
        <td class='" . ($rewriteEnabled ? 'success' : 'error') . "'>" . 
        ($rewriteEnabled ? 'Yes' : 'No') . "</td>
      </tr>";

echo "</table>

<h2>Configuration Check</h2>
<table>
    <tr>
        <th>Setting</th>
        <th>Value</th>
    </tr>
    <tr>
        <td>BASE_URL</td>
        <td>" . BASE_URL . "</td>
    </tr>
    <tr>
        <td>ADMIN_URL</td>
        <td>" . ADMIN_URL . "</td>
    </tr>
    <tr>
        <td>.htaccess Files</td>
        <td>" . (file_exists(__DIR__ . '/.htaccess') && file_exists(__DIR__ . '/adminlte/.htaccess') ? 
            "<span class='success'>Both present</span>" : 
            "<span class='error'>Missing one or both</span>") . "</td>
    </tr>
</table>

<h2>Recommendations</h2>";

if (!$rewriteEnabled) {
    echo "<p class='error'>mod_rewrite does not appear to be enabled. Please enable it in your Apache configuration.</p>";
    echo "<pre>
sudo a2enmod rewrite
sudo service apache2 restart</pre>";
}

if (!file_exists(__DIR__ . '/.htaccess') || !file_exists(__DIR__ . '/adminlte/.htaccess')) {
    echo "<p class='error'>One or both .htaccess files are missing. Please create them.</p>";
}

echo "<p>If you're still having issues, check your Apache configuration to ensure AllowOverride is set to All:</p>
<pre>
&lt;Directory /var/www/html&gt;
    AllowOverride All
&lt;/Directory&gt;
</pre>

</body>
</html>";
