<?php
// Test database connection with different credentials
echo "Testing database connections...\n\n";

// Test configurations
$configs = [
    'Local Development' => [
        'host' => 'localhost',
        'dbname' => 'ktxmmosu_kso_chandigarh',
        'username' => 'root',
        'password' => ''
    ],
    'Production (Current)' => [
        'host' => 'localhost',
        'dbname' => 'ktxmmosu_kso_chandigarh',
        'username' => 'ktxmmosu_kso_db',
        'password' => 'KSO@2025'
    ],
    'Alternative Production' => [
        'host' => 'localhost',
        'dbname' => 'ktxmmosu_kso_chandigarh',
        'username' => 'ktxmmosu_kso_chandigarh',
        'password' => 'KSO@2025'
    ]
];

foreach ($configs as $name => $config) {
    echo "Testing: $name\n";
    echo "Host: {$config['host']}\n";
    echo "Database: {$config['dbname']}\n";
    echo "Username: {$config['username']}\n";
    echo "Password: " . (empty($config['password']) ? '(empty)' : '(set)') . "\n";
    
    try {
        $pdo = new PDO(
            "mysql:host={$config['host']};dbname={$config['dbname']};charset=utf8mb4",
            $config['username'],
            $config['password'],
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
            ]
        );
        
        // Test a simple query
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM admins");
        $result = $stmt->fetch();
        
        echo "✅ SUCCESS: Connected successfully!\n";
        echo "   Admin count: {$result['count']}\n";
        
    } catch (PDOException $e) {
        echo "❌ ERROR: " . $e->getMessage() . "\n";
    }
    
    echo "\n" . str_repeat("-", 50) . "\n\n";
}

// Test if database exists at all
echo "Testing database existence with root user...\n";
try {
    $pdo = new PDO(
        "mysql:host=localhost;charset=utf8mb4",
        'root',
        '',
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    
    $stmt = $pdo->query("SHOW DATABASES");
    $databases = $stmt->fetchAll();
    
    echo "Available databases:\n";
    foreach ($databases as $db) {
        echo "  - {$db['Database']}\n";
    }
    
    // Check if our target database exists
    $stmt = $pdo->query("SHOW DATABASES LIKE 'ktxmmosu_kso_chandigarh'");
    $found = $stmt->fetch();
    
    if ($found) {
        echo "\n✅ Database 'ktxmmosu_kso_chandigarh' exists!\n";
    } else {
        echo "\n❌ Database 'ktxmmosu_kso_chandigarh' does not exist!\n";
    }
    
} catch (PDOException $e) {
    echo "❌ Cannot connect to MySQL server: " . $e->getMessage() . "\n";
}
?>
