<?php
require_once '../config/database.php';

header('Content-Type: application/json');

try {
    $pdo = getDBConnection();

    // Get member statistics
    $member_stats = $pdo->query("
        SELECT 
            COUNT(*) as total_members,
            COUNT(CASE WHEN status = 'active' THEN 1 END) as active_members,
            COUNT(CASE WHEN status = 'pending' THEN 1 END) as pending_members,
            COUNT(CASE WHEN status = 'approved' THEN 1 END) as approved_members
        FROM members
    ")->fetch();

    // Get event statistics
    $event_stats = $pdo->query("
        SELECT 
            COUNT(*) as total_events,
            COUNT(CASE WHEN status = 'upcoming' THEN 1 END) as upcoming_events,
            COUNT(CASE WHEN status = 'completed' THEN 1 END) as completed_events
        FROM events
    ")->fetch();

    // Get financial statistics
    $finance_stats = $pdo->query("
        SELECT 
            COUNT(*) as total_transactions,
            COALESCE(SUM(CASE WHEN status = 'completed' THEN amount ELSE 0 END), 0) as total_income,
            COUNT(CASE WHEN status = 'pending' THEN 1 END) as pending_payments
        FROM finance
    ")->fetch();

    // Get expense statistics
    $expense_stats = $pdo->query("
        SELECT 
            COUNT(*) as total_expenses,
            COALESCE(SUM(CASE WHEN status = 'approved' THEN amount ELSE 0 END), 0) as total_expenses_amount,
            COUNT(CASE WHEN status = 'pending' THEN 1 END) as pending_expenses
        FROM expenses
    ")->fetch();

    echo json_encode([
        'success' => true, 
        'data' => [
            'members' => $member_stats,
            'events' => $event_stats,
            'finance' => $finance_stats,
            'expenses' => $expense_stats
        ]
    ]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
