<?php
require_once '../config/database.php';

header('Content-Type: application/json');

try {
    $pdo = getDBConnection();

    $stats = $pdo->query("
        SELECT 
            COUNT(*) as total,
            COUNT(CASE WHEN status = 'upcoming' THEN 1 END) as upcoming,
            COUNT(CASE WHEN status = 'ongoing' THEN 1 END) as ongoing,
            COUNT(CASE WHEN status = 'completed' THEN 1 END) as completed,
            COUNT(CASE WHEN status = 'cancelled' THEN 1 END) as cancelled
        FROM events
    ")->fetch();

    echo json_encode(['success' => true, 'data' => $stats]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
