<?php
require_once '../config/database.php';

header('Content-Type: application/json');

try {
    $pdo = getDBConnection();

    $stmt = $pdo->query("
        SELECT f.*, CONCAT(m.first_name, ' ', m.last_name) as member_name
        FROM finance f
        LEFT JOIN members m ON f.member_id = m.id
        ORDER BY f.created_at DESC
    ");
    $finance = $stmt->fetchAll();

    echo json_encode(['success' => true, 'data' => $finance]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
