<?php
require_once '../config.php';
require_once '../auth/check_auth.php';

header('Content-Type: application/json');

if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

try {
    // Get members who don't have active ID cards
    $query = "
        SELECT 
            m.id,
            m.first_name,
            m.last_name,
            m.kso_id,
            m.membership_type,
            m.photo_url,
            CONCAT(m.first_name, ' ', m.last_name) as name
        FROM members m
        LEFT JOIN id_cards ic ON m.id = ic.member_id AND ic.status = 'active'
        WHERE ic.id IS NULL
        AND m.status = 'active'
        ORDER BY m.first_name, m.last_name
    ";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $members = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'members' => $members
    ]);
    
} catch (Exception $e) {
    error_log("Members Without Cards Error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching members: ' . $e->getMessage()
    ]);
}
?>
