<?php
require_once 'config/database.php';

// Check if already logged in
if (checkAuthentication()) {
    header('Location: index.php');
    exit;
}

require_once 'templates/header.php';
?>

<div class="login-page">
    <div class="login-box">
        <div class="login-logo">
            <a href="#"><b>KSO</b> Admin</a>
        </div>
        <!-- /.login-logo -->
        <div class="card">
            <div class="card-body login-card-body">
                <p class="login-box-msg">Reset your password</p>

                <div id="resetMessages"></div>

                <form id="resetForm" action="auth/reset-password.php" method="post">
                    <div class="input-group mb-3">
                        <input type="email" name="email" id="email" class="form-control" placeholder="Email" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-envelope"></span>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <button type="submit" id="resetBtn" class="btn btn-primary btn-block">
                                <span class="btn-text">Send Reset Link</span>
                                <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                            </button>
                        </div>
                        <!-- /.col -->
                    </div>
                </form>

                <p class="mt-3 mb-1">
                    <a href="login.php">Back to Login</a>
                </p>
                
                <div class="mt-3">
                    <small class="text-muted">
                        <i class="fas fa-info-circle"></i> 
                        Enter your email address and we'll send you a link to reset your password.
                    </small>
                </div>
            </div>
            <!-- /.login-card-body -->
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#resetForm').on('submit', function(e) {
        e.preventDefault();
        
        const btn = $('#resetBtn');
        const btnText = btn.find('.btn-text');
        const spinner = btn.find('.spinner-border');
        
        // Show loading state
        btn.prop('disabled', true);
        btnText.text('Sending...');
        spinner.removeClass('d-none');
        
        // Clear previous messages
        $('#resetMessages').empty();
        
        $.ajax({
            url: 'auth/reset-password.php',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    $('#resetMessages').html(
                        '<div class="alert alert-success"><i class="fas fa-check"></i> ' + response.message + '</div>'
                    );
                    $('#resetForm')[0].reset();
                } else {
                    $('#resetMessages').html(
                        '<div class="alert alert-danger"><i class="fas fa-exclamation-triangle"></i> ' + response.message + '</div>'
                    );
                }
            },
            error: function(xhr, status, error) {
                $('#resetMessages').html(
                    '<div class="alert alert-danger"><i class="fas fa-exclamation-triangle"></i> Failed to send reset link. Please try again.</div>'
                );
            },
            complete: function() {
                // Reset button state
                btn.prop('disabled', false);
                btnText.text('Send Reset Link');
                spinner.addClass('d-none');
            }
        });
    });
    
    // Auto-focus on email field
    $('#email').focus();
});
</script>

<?php
require_once 'templates/footer.php';
?>
