<?php
require_once 'config/database.php';

// Check if already logged in
if (checkAuthentication()) {
    header('Location: index.php');
    exit;
}

// Check for session expiry message
$expired_message = '';
if (isset($_GET['expired']) && $_GET['expired'] == '1') {
    $expired_message = 'Your session has expired. Please log in again.';
}

require_once 'templates/header.php';
?>

<div class="login-page">
    <div class="login-box">
        <div class="login-logo">
            <a href="#"><b>KSO</b> Admin</a>
        </div>
        <!-- /.login-logo -->
        <div class="card">
            <div class="card-body login-card-body">
                <p class="login-box-msg">Sign in to start your session</p>

                <?php if ($expired_message): ?>
                <div class="alert alert-warning alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <?php echo $expired_message; ?>
                </div>
                <?php endif; ?>

                <div id="loginMessages"></div>

                <form id="loginForm" action="auth/login.php" method="post">
                    <div class="input-group mb-3">
                        <input type="text" name="username" id="username" class="form-control" placeholder="Username or Email" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-user"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="password" name="password" id="password" class="form-control" placeholder="Password" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-lock"></span>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-8">
                            <div class="icheck-primary">
                                <input type="checkbox" id="remember_me" name="remember_me">
                                <label for="remember_me">
                                    Remember Me (30 days)
                                </label>
                            </div>
                        </div>
                        <!-- /.col -->
                        <div class="col-4">
                            <button type="submit" id="loginBtn" class="btn btn-primary btn-block">
                                <span class="btn-text">Sign In</span>
                                <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                            </button>
                        </div>
                        <!-- /.col -->
                    </div>
                </form>

                <p class="mb-1">
                    <a href="forgot-password.php">I forgot my password</a>
                </p>
                
                <div class="mt-3">
                    <small class="text-muted">
                        <i class="fas fa-shield-alt"></i> 
                        Secure login with account protection
                    </small>
                </div>
            </div>
            <!-- /.login-card-body -->
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#loginForm').on('submit', function(e) {
        e.preventDefault();
        
        const btn = $('#loginBtn');
        const btnText = btn.find('.btn-text');
        const spinner = btn.find('.spinner-border');
        
        // Show loading state
        btn.prop('disabled', true);
        btnText.text('Signing In...');
        spinner.removeClass('d-none');
        
        // Clear previous messages
        $('#loginMessages').empty();
        
        $.ajax({
            url: 'auth/login.php',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    $('#loginMessages').html(
                        '<div class="alert alert-success"><i class="fas fa-check"></i> ' + response.message + '</div>'
                    );
                    
                    // Redirect after short delay
                    setTimeout(function() {
                        window.location.href = response.redirect || 'index.php';
                    }, 1000);
                } else {
                    $('#loginMessages').html(
                        '<div class="alert alert-danger"><i class="fas fa-exclamation-triangle"></i> ' + response.message + '</div>'
                    );
                }
            },
            error: function(xhr, status, error) {
                $('#loginMessages').html(
                    '<div class="alert alert-danger"><i class="fas fa-exclamation-triangle"></i> Login failed. Please try again.</div>'
                );
            },
            complete: function() {
                // Reset button state
                btn.prop('disabled', false);
                btnText.text('Sign In');
                spinner.addClass('d-none');
            }
        });
    });
    
    // Auto-focus on username field
    $('#username').focus();
    
    // Show/hide password
    $('.input-group').on('click', '.fas.fa-lock', function() {
        const passwordField = $(this).closest('.input-group').find('input[type="password"], input[type="text"]');
        const icon = $(this);
        
        if (passwordField.attr('type') === 'password') {
            passwordField.attr('type', 'text');
            icon.removeClass('fa-lock').addClass('fa-unlock');
        } else {
            passwordField.attr('type', 'password');
            icon.removeClass('fa-unlock').addClass('fa-lock');
        }
    });
});
</script>

<?php
require_once 'templates/footer.php';
?>
